/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import org.h2.message.Message;
import org.h2.tools.RunScriptThread;
import org.h2.util.ScriptReader;

public class RunScript {
    private static final boolean MULTI_THREAD = false;

    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " -url <url> -user <user> [-password <pwd>] [-script <file>] [-driver <driver] [-options <option> ...]");
    }

    public static void main(String[] args) throws SQLException {
        new RunScript().run(args);
    }

    private void run(String[] args) throws SQLException {
        String url = null;
        String user = null;
        String password = "";
        String script = "backup.sql";
        String options = null;
        boolean continueOnError = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-url")) {
                url = args[++i];
                continue;
            }
            if (args[i].equals("-user")) {
                user = args[++i];
                continue;
            }
            if (args[i].equals("-password")) {
                password = args[++i];
                continue;
            }
            if (args[i].equals("-continueOnError")) {
                continueOnError = true;
                continue;
            }
            if (args[i].equals("-script")) {
                script = args[++i];
                continue;
            }
            if (args[i].equals("-driver")) {
                String driver = args[++i];
                try {
                    Class.forName(driver);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw Message.convert(e);
                }
            }
            if (args[i].equals("-options")) {
                StringBuffer buff = new StringBuffer();
                ++i;
                while (i < args.length) {
                    buff.append(' ');
                    buff.append(args[i]);
                    ++i;
                }
                options = buff.toString();
                continue;
            }
            this.showUsage();
            return;
        }
        if (url == null || user == null || password == null || script == null) {
            this.showUsage();
            return;
        }
        if (options != null) {
            RunScript.executeRunscript(url, user, password, script, options);
        } else {
            RunScript.execute(url, user, password, script, null, continueOnError);
        }
    }

    public static ResultSet execute(Connection conn, Reader reader) throws SQLException {
        String sql;
        Statement stat = conn.createStatement();
        ResultSet rs = null;
        ScriptReader r = new ScriptReader(reader);
        while ((sql = r.readStatement()) != null) {
            boolean resultset = stat.execute(sql);
            if (!resultset) continue;
            if (rs != null) {
                rs.close();
                rs = null;
            }
            rs = stat.getResultSet();
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String url, String user, String password, boolean continueOnError, Reader reader) throws SQLException {
        Connection conn = DriverManager.getConnection(url, user, password);
        HashMap map = new HashMap();
        try {
            String sql;
            Statement stat = conn.createStatement();
            ScriptReader r = new ScriptReader(reader);
            while ((sql = r.readStatement()) != null) {
                sql = sql.trim();
                try {
                    stat.execute(sql);
                }
                catch (SQLException e) {
                    if (continueOnError) {
                        e.printStackTrace();
                        continue;
                    }
                    throw e;
                }
            }
            Iterator it = map.values().iterator();
            while (it.hasNext()) {
                RunScriptThread thread = (RunScriptThread)it.next();
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeRunscript(String url, String user, String password, String fileName, String options) throws SQLException {
        try {
            Class.forName("org.h2.Driver");
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement stat = conn.createStatement();
            String sql = "RUNSCRIPT FROM '" + fileName + "' " + options;
            try {
                stat.execute(sql);
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String url, String user, String password, String fileName, String charsetName, boolean continueOnError) throws SQLException {
        try {
            Class.forName("org.h2.Driver");
            if (charsetName == null) {
                charsetName = "UTF8";
            }
            FileInputStream in = new FileInputStream(fileName);
            try {
                BufferedInputStream bin = new BufferedInputStream(in, 4096);
                InputStreamReader inReader = new InputStreamReader((InputStream)bin, charsetName);
                RunScript.execute(url, user, password, continueOnError, inReader);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            throw Message.convert(e);
        }
    }
}

