/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;


/**
 * テーブルBuriStateとマッピング関係にあるテーブルに対応するDtoです。
 * @author S2Dao-CodeGen
 */
public abstract class AbstractBuristateRelation extends AbstractBuristate {

	private Buripath buripathEntity;
	
	private Buridata buridataEntity;
	
	private Buribranch buribranchEntity;
	

	/**
	 * BuriPathに対応するEntityを返します。
	 * @return BuriPathに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "PathID:PathID", relationNo = 0)
	public Buripath getBuripathEntity() {
		return this.buripathEntity;
	}

	/**
	 * BuriPathに対応するDtoを設定します。
	 * @param buripathEntity BuriPathに対応するEntity
	 */
	public void setBuripathEntity(Buripath buripathEntity) {
		this.buripathEntity = buripathEntity;
	}
	/**
	 * BuriDataに対応するEntityを返します。
	 * @return BuriDataに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "DataID:DataID", relationNo = 1)
	public Buridata getBuridataEntity() {
		return this.buridataEntity;
	}

	/**
	 * BuriDataに対応するDtoを設定します。
	 * @param buridataEntity BuriDataに対応するEntity
	 */
	public void setBuridataEntity(Buridata buridataEntity) {
		this.buridataEntity = buridataEntity;
	}
	/**
	 * BuriBranchに対応するEntityを返します。
	 * @return BuriBranchに対応するEntity
	 */
	@org.seasar.dao.annotation.tiger.Relation(relationKey = "BranchID:BranchID", relationNo = 2)
	public Buribranch getBuribranchEntity() {
		return this.buribranchEntity;
	}

	/**
	 * BuriBranchに対応するDtoを設定します。
	 * @param buribranchEntity BuriBranchに対応するEntity
	 */
	public void setBuribranchEntity(Buribranch buribranchEntity) {
		this.buribranchEntity = buribranchEntity;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append(super.toString());
		buf.append("buripathEntity").append(buripathEntity);
		buf.append("buridataEntity").append(buridataEntity);
		buf.append("buribranchEntity").append(buribranchEntity);
		return buf.toString();
	}

}
