/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriDataPathHistoryテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuridatapathhistory {

	private Long historyid;
	private Long pathid;
	private Long dataid;
	private String useridval;
	private Integer useridnum;
	private java.util.Date insertdate;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * historyIDを返します。
	 * @return historyID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("historyID")
	public Long getHistoryid() {
		return historyid;
	}

	/**
	 * historyIDを設定します。
	 * @param historyid historyID
	 */
	public void setHistoryid(Long historyid) {
		modifiedPropertySet.add("historyid");
		this.historyid = historyid;
	}

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathid() {
		return pathid;
	}

	/**
	 * PathIDを設定します。
	 * @param pathid PathID
	 */
	public void setPathid(Long pathid) {
		modifiedPropertySet.add("pathid");
		this.pathid = pathid;
	}

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataid() {
		return dataid;
	}

	/**
	 * DataIDを設定します。
	 * @param dataid DataID
	 */
	public void setDataid(Long dataid) {
		modifiedPropertySet.add("dataid");
		this.dataid = dataid;
	}

	/**
	 * UserIDValを返します。
	 * @return UserIDVal
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDVal")
	public String getUseridval() {
		return useridval;
	}

	/**
	 * UserIDValを設定します。
	 * @param useridval UserIDVal
	 */
	public void setUseridval(String useridval) {
		modifiedPropertySet.add("useridval");
		this.useridval = useridval;
	}

	/**
	 * UserIDNumを返します。
	 * @return UserIDNum
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDNum")
	public Integer getUseridnum() {
		return useridnum;
	}

	/**
	 * UserIDNumを設定します。
	 * @param useridnum UserIDNum
	 */
	public void setUseridnum(Integer useridnum) {
		modifiedPropertySet.add("useridnum");
		this.useridnum = useridnum;
	}

	/**
	 * insertDateを返します。
	 * @return insertDate
	 */
	@org.seasar.dao.annotation.tiger.Column("insertDate")
	public java.util.Date getInsertdate() {
		return insertdate;
	}

	/**
	 * insertDateを設定します。
	 * @param insertdate insertDate
	 */
	public void setInsertdate(java.util.Date insertdate) {
		modifiedPropertySet.add("insertdate");
		this.insertdate = insertdate;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/historyid=").append(historyid);
		buff.append("/pathid=").append(pathid);
		buff.append("/dataid=").append(dataid);
		buff.append("/useridval=").append(useridval);
		buff.append("/useridnum=").append(useridnum);
		buff.append("/insertdate=").append(insertdate);
		buff.append("]");
		return buff.toString();
	}

}
