/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriDataテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuridata {

	private Long dataid;
	private String pkeyval;
	private Long pkeynum;
	private String datatype = "";
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataid() {
		return dataid;
	}

	/**
	 * DataIDを設定します。
	 * @param dataid DataID
	 */
	public void setDataid(Long dataid) {
		modifiedPropertySet.add("dataid");
		this.dataid = dataid;
	}

	/**
	 * pkeyValを返します。
	 * @return pkeyVal
	 */
	@org.seasar.dao.annotation.tiger.Column("pkeyVal")
	public String getPkeyval() {
		return pkeyval;
	}

	/**
	 * pkeyValを設定します。
	 * @param pkeyval pkeyVal
	 */
	public void setPkeyval(String pkeyval) {
		modifiedPropertySet.add("pkeyval");
		this.pkeyval = pkeyval;
	}

	/**
	 * pkeyNumを返します。
	 * @return pkeyNum
	 */
	@org.seasar.dao.annotation.tiger.Column("pkeyNum")
	public Long getPkeynum() {
		return pkeynum;
	}

	/**
	 * pkeyNumを設定します。
	 * @param pkeynum pkeyNum
	 */
	public void setPkeynum(Long pkeynum) {
		modifiedPropertySet.add("pkeynum");
		this.pkeynum = pkeynum;
	}

	/**
	 * dataTypeを返します。
	 * @return dataType
	 */
	@org.seasar.dao.annotation.tiger.Column("dataType")
	public String getDatatype() {
		return datatype;
	}

	/**
	 * dataTypeを設定します。
	 * @param datatype dataType
	 */
	public void setDatatype(String datatype) {
		modifiedPropertySet.add("datatype");
		this.datatype = datatype;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/dataid=").append(dataid);
		buff.append("/pkeyval=").append(pkeyval);
		buff.append("/pkeynum=").append(pkeynum);
		buff.append("/datatype=").append(datatype);
		buff.append("]");
		return buff.toString();
	}

}
