/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.dao;

import java.util.List;

import org.seasar.codegen.sample.camel.entity.Buristate;
import org.seasar.codegen.sample.camel.condition.BuristateCondition;
import org.seasar.codegen.sample.camel.entity.BuristateRelation;
import org.seasar.codegen.sample.camel.condition.BuristateRelationCondition;
/**
 * BuriStateテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはBuristateDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = Buristate.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface BuristateCore {

	/**
	 * BuriStateのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY StateID")
	public List<Buristate> getAllBuristate();


	/**
	 * 引数が主キーと一致するBuriStateのEntityを取得します。
	 *
	 * @param stateid 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("StateID = ?")
	public Buristate getBuristate(Long stateid);


	/**
	 * 引数が主キーと一致するBuriStateのEntityのリストを主キーでソートして取得します。
	 *
	 * @param stateids  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("stateids")
	@org.seasar.dao.annotation.tiger.Query("StateID in /*stateids*/(1) ORDER BY StateID")
	public List<Buristate> getBuristateByIds(Long ... stateids);
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<Buristate> find(BuristateCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public Buristate soleMatch(BuristateCondition condition);


	/**
	 * BuriStateのEntityを関連先も含めて全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY StateID")
	public List<BuristateRelation> getAllBuristateWithRelation();


	/**
	 * 引数が主キーと一致するBuriStateのEntityを関連先も含めて取得します。
	 *
	 * @param stateid 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("StateID  = ? ORDER BY StateID")
	public BuristateRelation getBuristateWithRelation(Long stateid);


	/**
	 * 引数が主キーと一致するBuriStateのEntityのリストを関連先も含めて主キーでソートして取得します。
	 *
	 * @param stateids  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("stateids")
	@org.seasar.dao.annotation.tiger.Query("StateID in /*stateids*/(1) ORDER BY StateID")
	public List<BuristateRelation> getBuristateByIdsWithRelation(Object ... stateids);
	
	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<BuristateRelation> findWithRelation(BuristateRelationCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを関連先も含めて取得します。
	 *
	 * @param condition 検索条件を指定したCondition
	 * @return Entityのリスト。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public BuristateRelation soleMatchWithRelation(BuristateRelationCondition condition);
	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(Buristate entity);
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(Buristate entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(Buristate entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(Buristate entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(Buristate entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(Buristate entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<Buristate> entityList);
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<Buristate> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<Buristate> entityList);

}

