/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.codegen.CodeGenConfig;
import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.convert.FKNameConverter;
import org.seasar.codegen.dbms.Dbms;
import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.FieldSetting;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.codegen.exception.InternalGenerateException;
import org.seasar.codegen.exception.NotTypeMatchException;
import org.seasar.codegen.util.CreateTableTypeToTypeUtil;
import org.seasar.codegen.util.IdentityUtil;
import org.seasar.codegen.util.LinkUtil;
import org.seasar.codegen.util.SequnceUtil;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.extension.jdbc.util.DataSourceUtil;
import org.seasar.extension.jdbc.util.DatabaseMetaDataUtil;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseImportCodeData
implements ImportCodeData {
    protected Dbms dbms;
    private Set<String> tables = new HashSet<String>();
    private String ignoreTablePattern;
    private DataSource dataSource;
    protected String schemaName = null;
    private CodeGenConfig codeGenConfig;
    private FKNameConverter fkNameConverter;
    private static Log log = LogFactory.getLog(DatabaseImportCodeData.class);

    public DatabaseImportCodeData(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Table> readCodeData(File srcFile) {
        Connection con = null;
        try {
            con = DataSourceUtil.getConnection((DataSource)this.dataSource);
            Map<String, Table> map = this.createMap(con);
            return map;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Table> createMap(Connection connection) {
        HashMap<String, Table> hashMap;
        HashMap<String, Table> tableMap = new HashMap<String, Table>();
        DatabaseMetaData dbmd = ConnectionUtil.getMetaData((Connection)connection);
        ResultSet rsTable = dbmd.getTables(null, this.schemaName, "%", null);
        Pattern ignoreTable = null;
        if (this.ignoreTablePattern != null) {
            ignoreTable = Pattern.compile(this.ignoreTablePattern);
        }
        String recycle = this.getRecyleTableName(dbmd);
        try {
            while (rsTable.next()) {
                Table table = new Table();
                String tableName = rsTable.getString("TABLE_NAME");
                log.debug((Object)("table name:" + tableName));
                log.debug((Object)("table type:" + rsTable.getString("TABLE_TYPE")));
                String type = rsTable.getString("TABLE_TYPE");
                if (!type.equals("TABLE") && !type.equals("VIEW")) continue;
                if (type.equals("VIEW")) {
                    table.setView(true);
                }
                if (ignoreTable != null && ignoreTable.matcher(tableName).matches() || !StringUtil.isEmpty((String)recycle) && tableName.startsWith(recycle) || !this.tables.isEmpty() && !this.tables.contains(tableName)) continue;
                table.setTableName(tableName);
                String[] primaryKeys = DatabaseMetaDataUtil.getPrimaryKeys((DatabaseMetaData)dbmd, (String)tableName);
                ResultSet rsColumn = dbmd.getColumns(null, this.schemaName, tableName, "%");
                try {
                    while (rsColumn.next()) {
                        Field field = this.getField(tableName, rsColumn);
                        table.addTableField(field);
                        this.setUpPrimaryKey(table, field, primaryKeys);
                    }
                    tableMap.put(table.getTableName(), table);
                }
                finally {
                    ResultSetUtil.close((ResultSet)rsColumn);
                }
            }
            for (Table table : tableMap.values()) {
                ResultSet rsExKey = dbmd.getExportedKeys(null, this.schemaName, table.getTableName());
                try {
                    while (rsExKey.next()) {
                        LinkTable parentLink = this.getParentLink(rsExKey);
                        Table childTable = (Table)tableMap.get(rsExKey.getString("FKTABLE_NAME"));
                        if (childTable == null) continue;
                        childTable.addLinkTable(childTable.getTableName(), parentLink);
                    }
                }
                finally {
                    ResultSetUtil.close((ResultSet)rsExKey);
                }
            }
            LinkUtil.setupChildLinks(tableMap);
            hashMap = tableMap;
        }
        catch (Throwable throwable) {
            try {
                ResultSetUtil.close((ResultSet)rsTable);
                throw throwable;
            }
            catch (SQLException e) {
                throw new SQLRuntimeException(e);
            }
        }
        ResultSetUtil.close((ResultSet)rsTable);
        return hashMap;
    }

    private String getRecyleTableName(DatabaseMetaData dbmd) {
        String product = this.getDatabaseProductName(dbmd);
        if (product.startsWith("Oracle")) {
            return "BIN$";
        }
        return "";
    }

    protected String getDatabaseProductName(DatabaseMetaData dbmd) {
        return DatabaseMetaDataUtil.getDatabaseProductName((DatabaseMetaData)dbmd);
    }

    private LinkTable getParentLink(ResultSet rsExKey) throws SQLException {
        LinkTable link = new LinkTable();
        link.setTableName(rsExKey.getString("PKTABLE_NAME"));
        link.setParentFieldName(rsExKey.getString("PKCOLUMN_NAME"));
        link.setChildFieldName(rsExKey.getString("FKCOLUMN_NAME"));
        return link;
    }

    protected Field getField(String tableName, ResultSet rsColumn) throws SQLException {
        String columnName = rsColumn.getString(4);
        String typeName = rsColumn.getString(6);
        String strNotNull = this.getNotNull(rsColumn.getInt(11));
        int iColumnSize = rsColumn.getInt(7);
        int decimalDegit = rsColumn.getInt(9);
        String columnSize = null;
        columnSize = decimalDegit != 0 ? "(" + iColumnSize + "," + decimalDegit + ")" : "(" + iColumnSize + ")";
        Field field = new Field();
        field.setFieldName(columnName);
        field.setFieldAttributeName(columnName);
        String columnDef = rsColumn.getString(13);
        if (columnDef == null) {
            columnDef = "";
        }
        try {
            field.setDataType(this.getDataType(typeName, columnSize, strNotNull, ""));
        }
        catch (InternalGenerateException e) {
            throw new NotTypeMatchException(tableName, columnName, e);
        }
        return field;
    }

    protected void setUpPrimaryKey(Table table, Field field, String[] primaryKeys) {
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (!primaryKeys[i].equalsIgnoreCase(field.getFieldName())) continue;
            Map<String, String> sequnceMap = this.codeGenConfig.getSequnceMapping();
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setField(field);
            if (sequnceMap != null && sequnceMap.get(table.getTableName()) != null) {
                SequnceUtil.addSequence(primaryKey, sequnceMap.get(table.getTableName()));
            } else if (IdentityUtil.isIdentityConfig(this.codeGenConfig.getIdentityType())) {
                field.setUseIdentity(true);
            } else if (IdentityUtil.isSequenceConfig(this.codeGenConfig.getIdentityType())) {
                field.setSequence(field.getFieldNameForDto());
            }
            table.addPrimaryKey(primaryKey);
        }
    }

    protected DataType getDataType(String dataType, String columnSize, String notNull, String defaultValue) throws InternalGenerateException {
        FieldSetting fieldSetting = new FieldSetting();
        String langType = this.dbms.convDBTypeToDataType(dataType);
        fieldSetting.setTypeName(langType);
        String length = CreateTableTypeToTypeUtil.getLength(dataType + columnSize, dataType);
        int precision = CreateTableTypeToTypeUtil.getFullLength(length);
        fieldSetting.setColmnSize(precision);
        int scale = CreateTableTypeToTypeUtil.getPointNumberLength(length);
        fieldSetting.setPointNumber(scale);
        boolean isNotNull = "NOT NULL".equalsIgnoreCase(notNull);
        fieldSetting.setNotNull(isNotNull);
        fieldSetting.setFieldDefault(defaultValue);
        DataType type = this.dbms.selectBestDataType(fieldSetting);
        return type;
    }

    protected String getNotNull(int notNull) {
        if (notNull == 0) {
            return "NOT NULL";
        }
        return "";
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDataTypeSelectUtil(Dbms dataTypeSelectUtil) {
        this.dbms = dataTypeSelectUtil;
    }

    public void addTable(String tableName) {
        this.tables.add(tableName);
    }

    public void setIgnoreTablePattern(String ignoreTablePattern) {
        this.ignoreTablePattern = ignoreTablePattern;
    }

    public void setDbms(Dbms dbms) {
        this.dbms = dbms;
    }

    public void setFKNameConverter(FKNameConverter converter) {
        this.fkNameConverter = converter;
    }

    public void setCodeGenConfig(CodeGenConfig codeGenConfig) {
        this.codeGenConfig = codeGenConfig;
    }
}

