/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.unit.util;

import junit.framework.Assert;

import org.seasar.codegen.element.DataType;
import org.seasar.codegen.element.lang.JavaDataType;

public class AssertUtil {

    public static void assertDataType(String message, String expectType,
            DataType actualDataType) {
        JavaDataType javaType = (JavaDataType) actualDataType.getLangDataType();
        Assert.assertEquals(message, expectType.replace("java.lang.", ""),
                javaType.getClassName());
    }
}
