/*
 * Copyright 2004-2010 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import static org.junit.Assert.*;

import java.io.File;
import java.io.FileNotFoundException;

import org.jiemamy.JiemamyContext;
import org.jiemamy.serializer.JiemamySerializer;
import org.jiemamy.serializer.SerializationException;
import org.junit.Test;
import org.seasar.codegen.exception.CodeGenException;

public class JiemamyImportCodeDataExceptionTest {
    @Test
    public void デシリアライズ時にSerializationExceptionが発生した場合() throws Exception {
        JiemamyImportCodeData target = new JiemamyImportCodeData() {

            @Override
            JiemamyContext deserialize(File srcFile,
                    JiemamySerializer serializer)
                    throws SerializationException, FileNotFoundException {
                throw new SerializationException();
            }

        };
        try {
            target.readCodeData(null);
            fail();
        } catch (CodeGenException e) {
            String result = e.getMessage();
            System.out.println(result);
            assertTrue(true);
        }
    }

    @Test
    public void デシリアライズ時にFileNotFoundExceptionが発生した場合() throws Exception {
        JiemamyImportCodeData target = new JiemamyImportCodeData() {

            @Override
            JiemamyContext deserialize(File srcFile,
                    JiemamySerializer serializer)
                    throws SerializationException, FileNotFoundException {
                throw new SerializationException();
            }

        };
        try {
            target.readCodeData(null);
            fail();
        } catch (CodeGenException e) {
            String result = e.getMessage();
            System.out.println(result);
            assertTrue(true);
        }
    }

}
