/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl.util;

import org.seasar.codegen.util.CreateTableTypeToTypeUtil;

import junit.framework.TestCase;

public class CreateTableTypeToTypeUtilTest extends TestCase {

    public void testGetLengthFromDecimal() throws Exception {
        assertEquals("5,2", CreateTableTypeToTypeUtil.getLength("DECIMAL(5,2)",
                "DECIMAL"));
    }

    public void no_testFIXME_getFullLength() throws Exception {
        try {
            CreateTableTypeToTypeUtil.getFullLength("5,2");
            fail();
        } catch (NullPointerException caused) {
        }
    }

    public void no_testFIXME_getPointNumberLength() throws Exception {
        try {
            CreateTableTypeToTypeUtil.getPointNumberLength("5,2");
            fail();
        } catch (NumberFormatException caused) {
        }
    }

    public void testIntegerSpecLearning() throws Exception {
        assertNull(Integer.getInteger("5"));
    }

    public void testGetFullLengthFromDecimalString() throws Exception {
        assertEquals(5, CreateTableTypeToTypeUtil.getFullLength("5,2"));
    }

    public void testGetPointNumberLengthFromDecimalString() throws Exception {
        assertEquals(2, CreateTableTypeToTypeUtil.getPointNumberLength("5,2"));
    }
}
