/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.sql.DatabaseMetaData;
import java.util.List;
import java.util.Map;

import javax.sql.DataSource;

import org.seasar.codegen.ImportCodeData;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;
import org.seasar.extension.unit.S2TestCase;

/**
 * @author azusa
 * 
 */
public class DatabaseImportCodeDataTest extends S2TestCase {

    private ImportCodeData importCodeData;

    public void setUpReadCodeData() {
        include("DatabaseImportCodeDataTest.dicon");
    }

    public void testReadCodeData() {

        Map<String, Table> map = importCodeData.readCodeData(null);

        assertNotNull("1", map);

        Table table = map.get("EMP4");
        assertEquals("2", "EMP4", table.getTableName());
        Field field = table.getTableField("ENAME");
        assertEquals("3", "ENAME", field.getFieldName());
        assertEquals("4", "VARCHAR", field.getDataType().getRdbTypeName());
        assertEquals("5", 10, field.getDataType().getColmnSize());

        field = table.getTableField("COMM");
        assertEquals("6", 7, field.getDataType().getColmnSize());
        assertEquals("7", 2, field.getDataType().getPointNumber());

        List<PrimaryKey> primaryKeys = table.getPrimaryKey();
        PrimaryKey primaryKey = primaryKeys.get(0);
        assertEquals("8", "EMPNO", primaryKey.getField().getFieldName());
        assertEquals("81", "EMPNO", primaryKey.getField()
                .getFieldAttributeName());
        assertTrue("82", primaryKey.getField().isUseSequence());
        assertEquals("84", false, primaryKey.getField().isUseIdentity());

        LinkTable parentLink = (LinkTable) table.getParentTable().get(0);
        assertNotNull("9", parentLink);
        assertEquals("10", "DEPT4", parentLink.getTableName());

        Table parent = map.get("DEPT4");
        LinkTable childLink = (LinkTable) parent.getChildTable().get(0);
        assertEquals("11", "EMP4", childLink.getTableName());

        Table view = map.get("EMP_VIEW");
        assertNotNull("12", view);

        assertEquals("13", 3, map.keySet().size());
        assertTrue("14", view.isView());
    }

    public void setUpIgnore() {
        include("DatabaseImportCodeDataIgnoreTest.dicon");
    }

    public void testIgnore() {
        Map<String, Table> map = importCodeData.readCodeData(null);

        assertNotNull(map);

        assertNull(map.get("EMP4"));
        assertNotNull(map.get("DEPT4"));
    }

    public void setUpOracle() {
        include("DatabaseImportCodeDataOracleTest.dicon");
    }

    public void testOracle() {
        Map<String, Table> map = importCodeData.readCodeData(null);

        assertNotNull(map);
        assertNotNull(map.get("EMP4"));
        assertNull(map.get("BIN$EMP4"));
    }

    public static class OracleDatabaseImportCodeData extends
            DatabaseImportCodeData {

        public OracleDatabaseImportCodeData(DataSource dataSource) {
            super(dataSource);
        }

        @Override
        protected String getDatabaseProductName(DatabaseMetaData dbmd) {
            return "Oracle";
        }

    }

}
