/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.URLUtil;

public class ZipFileUtil {
    protected ZipFileUtil() {
    }

    public static ZipFile create(String file) {
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile create(File file) {
        try {
            return new ZipFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(ZipFile file, ZipEntry entry) {
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static ZipFile toZipFile(URL zipUrl) {
        return ZipFileUtil.create(new File(ZipFileUtil.toZipFilePath(zipUrl)));
    }

    public static String toZipFilePath(URL zipUrl) {
        String urlString = zipUrl.getPath();
        int pos = urlString.lastIndexOf(33);
        String zipFilePath = urlString.substring(0, pos);
        File zipFile = new File(URLUtil.decode(zipFilePath, "UTF8"));
        return FileUtil.getCanonicalPath(zipFile);
    }

    public static void close(ZipFile zipFile) {
        try {
            zipFile.close();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

