/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.PropertyTypeImpl;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.framework.util.CaseInsensitiveMap;
import org.seasar.framework.util.StringUtil;

public abstract class AbstractMapResultSetHandler
implements ResultSetHandler {
    protected Map createRow(ResultSet rs, PropertyType[] propertyTypes) throws SQLException {
        CaseInsensitiveMap row = new CaseInsensitiveMap();
        for (int i = 0; i < propertyTypes.length; ++i) {
            Object value = propertyTypes[i].getValueType().getValue(rs, i + 1);
            row.put(propertyTypes[i].getPropertyName(), value);
        }
        return row;
    }

    protected PropertyType[] createPropertyTypes(ResultSetMetaData rsmd) throws SQLException {
        int count = rsmd.getColumnCount();
        PropertyType[] propertyTypes = new PropertyType[count];
        for (int i = 0; i < count; ++i) {
            String propertyName = StringUtil.replace((String)rsmd.getColumnLabel(i + 1), (String)"_", (String)"");
            ValueType valueType = ValueTypes.getValueType((int)rsmd.getColumnType(i + 1));
            propertyTypes[i] = new PropertyTypeImpl(propertyName, valueType);
        }
        return propertyTypes;
    }
}

