/*
 * Decompiled with CFR 0.152.
 */
package jp.starlogic.servicemanager.service;

import java.util.Iterator;
import java.util.List;
import jp.starlogic.servicemanager.ServiceManager;
import jp.starlogic.servicemanager.ServiceMonitor;
import jp.starlogic.servicemanager.abst.AbstractGetRunService;
import org.seasar.framework.log.Logger;

public class StartupService
extends AbstractGetRunService {
    private static Logger logger = Logger.getLogger((Class)StartupService.class);
    private ServiceMonitor monitor;
    private ServiceManager manager;

    public boolean canService() {
        return true;
    }

    public void execute() {
        List smNames = this.monitor.getServiceNames();
        Iterator ite = smNames.iterator();
        while (ite.hasNext()) {
            String smName = ite.next().toString();
            ServiceMonitor.ServiceInfo info = this.monitor.getServiceInfo(smName);
            this.statusUpdate(info, smName);
        }
    }

    private void statusUpdate(ServiceMonitor.ServiceInfo info, String smName) {
        if (info.getStatus() == 0) {
            this.statusIsWait(info, smName);
        } else if (info.getStatus() == 1) {
            this.statusIsRunning(info);
        } else if (info.getStatus() == 2) {
            this.statusIsTerminate(info, smName);
        } else {
            this.stopCheckAndTerminate(info);
        }
    }

    protected void statusIsTerminate(ServiceMonitor.ServiceInfo info, String smName) {
        if (!info.getThread().isAlive() && info.getOneService().canReExecute()) {
            this.manager.executeService(smName);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("statusUpdate reRun" + info));
            }
        }
    }

    protected void statusIsRunning(ServiceMonitor.ServiceInfo info) {
        if (!info.getThread().isAlive()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("statusUpdate Thread is dead" + info));
            }
            info.getExecuteService().terminate();
        }
    }

    protected void statusIsWait(ServiceMonitor.ServiceInfo info, String smName) {
        if (info.getThread().isAlive()) {
            logger.fatal((Object)("statusUpdate getThread().isAlive()!! " + info));
        } else {
            this.manager.executeService(smName);
        }
    }

    protected void stopCheckAndTerminate(ServiceMonitor.ServiceInfo info) {
        if (info.getOneService().getStopCheckInterval() <= 0L) {
            return;
        }
        long aliveCheck = this.getTimeInMillis() - info.getStatusUpdateTime();
        if (aliveCheck >= info.getOneService().getStopCheckInterval()) {
            info.getExecuteService().terminate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("statusUpdate TimeOrver" + info));
            }
        }
    }

    public void destroyService() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"destroyService");
        }
        List smNames = this.monitor.getServiceNames();
        Iterator ite = smNames.iterator();
        while (ite.hasNext()) {
            String smName = ite.next().toString();
            ServiceMonitor.ServiceInfo info = this.monitor.getServiceInfo(smName);
            info.getExecuteService().terminate();
        }
    }

    protected long getTimeInMillis() {
        return System.currentTimeMillis();
    }

    public ServiceManager getManager() {
        return this.manager;
    }

    public void setManager(ServiceManager manager) {
        this.manager = manager;
    }

    public ServiceMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(ServiceMonitor monitor) {
        this.monitor = monitor;
    }
}

