/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.dialect.TokenResolver;
import org.jiemamy.model.constraint.JmDeferrability;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.index.JmIndexColumn;
import org.jiemamy.model.sql.Keyword;
import org.jiemamy.model.sql.Literal;
import org.jiemamy.model.sql.Separator;
import org.jiemamy.model.sql.Token;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.view.JmView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTokenResolver
implements TokenResolver {
    private static Logger logger = LoggerFactory.getLogger(DefaultTokenResolver.class);

    @Override
    public List<Token> resolve(Object value) {
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)5);
        if (value instanceof JmDeferrability.InitiallyCheckTime) {
            JmDeferrability.InitiallyCheckTime initiallyCheckTime = (JmDeferrability.InitiallyCheckTime)value;
            if (initiallyCheckTime == JmDeferrability.InitiallyCheckTime.IMMEDIATE) {
                tokens.add(Keyword.INITIALLY);
                tokens.add(Keyword.IMMEDIATE);
            } else if (initiallyCheckTime == JmDeferrability.InitiallyCheckTime.DEFERRED) {
                tokens.add(Keyword.INITIALLY);
                tokens.add(Keyword.DEFERRED);
            }
        } else if (value instanceof JmForeignKeyConstraint.MatchType) {
            JmForeignKeyConstraint.MatchType matchType = (JmForeignKeyConstraint.MatchType)value;
            if (matchType == JmForeignKeyConstraint.MatchType.SIMPLE) {
                tokens.add(Keyword.MATCH);
                tokens.add(Keyword.SIMPLE);
            } else if (matchType == JmForeignKeyConstraint.MatchType.FULL) {
                tokens.add(Keyword.MATCH);
                tokens.add(Keyword.FULL);
            } else if (matchType == JmForeignKeyConstraint.MatchType.PARTIAL) {
                tokens.add(Keyword.MATCH);
                tokens.add(Keyword.PARTIAL);
            }
        } else if (value instanceof JmForeignKeyConstraint.ReferentialAction) {
            JmForeignKeyConstraint.ReferentialAction referentialAction = (JmForeignKeyConstraint.ReferentialAction)value;
            if (referentialAction == JmForeignKeyConstraint.ReferentialAction.CASCADE) {
                tokens.add(Keyword.CASCADE);
            } else if (referentialAction == JmForeignKeyConstraint.ReferentialAction.SET_NULL) {
                tokens.add(Keyword.SET);
                tokens.add(Keyword.NULL);
            } else if (referentialAction == JmForeignKeyConstraint.ReferentialAction.SET_DEFAULT) {
                tokens.add(Keyword.SET);
                tokens.add(Keyword.DEFAULT);
            } else if (referentialAction == JmForeignKeyConstraint.ReferentialAction.RESTRICT) {
                tokens.add(Keyword.RESTRICT);
            } else if (referentialAction == JmForeignKeyConstraint.ReferentialAction.NO_ACTION) {
                tokens.add(Keyword.NO);
                tokens.add(Keyword.ACTION);
            }
        } else if (value instanceof JmIndexColumn.SortOrder) {
            JmIndexColumn.SortOrder sortOrder = (JmIndexColumn.SortOrder)value;
            if (sortOrder == JmIndexColumn.SortOrder.ASC) {
                tokens.add(Keyword.ASC);
            } else if (sortOrder == JmIndexColumn.SortOrder.DESC) {
                tokens.add(Keyword.DESC);
            }
        } else if (value instanceof JmTable) {
            tokens.add(Keyword.TABLE);
        } else if (value instanceof JmView) {
            tokens.add(Keyword.VIEW);
        } else if (value instanceof JmIndex) {
            tokens.add(Keyword.INDEX);
        } else if (value instanceof DataType) {
            tokens.addAll(this.resolveType((DataType)value));
        } else {
            logger.warn("unknown object: " + value.getClass());
        }
        return tokens;
    }

    protected List<Token> resolveType(DataType type) {
        Validate.notNull((Object)type);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)5);
        RawTypeDescriptor rawTypeDescriptor = type.getRawTypeDescriptor();
        result.add(Keyword.of(rawTypeDescriptor.getTypeName()));
        if (type.getParam(TypeParameterKey.SIZE) != null) {
            result.add(Separator.LEFT_PAREN);
            result.add(Literal.of((Number)type.getParam(TypeParameterKey.SIZE)));
            result.add(Separator.RIGHT_PAREN);
        } else if (type.getParam(TypeParameterKey.PRECISION) != null) {
            result.add(Separator.LEFT_PAREN);
            result.add(Literal.of((Number)type.getParam(TypeParameterKey.PRECISION)));
            if (type.getParam(TypeParameterKey.SCALE) != null) {
                result.add(Separator.COMMA);
                result.add(Literal.of((Number)type.getParam(TypeParameterKey.SCALE)));
            }
            result.add(Separator.RIGHT_PAREN);
        } else if (type.getParam(TypeParameterKey.WITH_TIMEZONE) != null) {
            if (((Boolean)type.getParam(TypeParameterKey.WITH_TIMEZONE)).booleanValue()) {
                result.add(Keyword.WITH);
            } else {
                result.add(Keyword.WITHOUT);
            }
            result.add(Keyword.TIMEZONE);
        }
        return result;
    }
}

