/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import java.net.URL;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.FacetProvider;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.SqlFacetStaxHandler;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.OnMemoryEntityResolver;
import org.jiemamy.dddbase.OnMemoryRepository;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.script.JmAroundScript;
import org.jiemamy.model.script.SimpleJmAroundScript;
import org.jiemamy.model.script.SimpleJmAroundScriptStaxHandler;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.transaction.StoredEvent;
import org.jiemamy.utils.LogMarker;
import org.jiemamy.xml.JiemamyNamespace;
import org.jiemamy.xml.JiemamyQName;
import org.jiemamy.xml.SqlNamespace;
import org.jiemamy.xml.SqlQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlFacet
implements JiemamyFacet {
    private static Logger logger = LoggerFactory.getLogger(SqlFacet.class);
    public static final FacetProvider PROVIDER = new FacetProvider(){

        public JiemamyFacet getFacet(JiemamyContext context) {
            return new SqlFacet(context);
        }

        public Class<? extends JiemamyFacet> getFacetType() {
            return SqlFacet.class;
        }
    };
    private final JiemamyContext context;
    private OnMemoryRepository<JmAroundScript> scripts = new OnMemoryRepository();
    private JmAroundScript universalAroundScript;

    private SqlFacet(JiemamyContext context) {
        Validate.notNull((Object)context);
        this.context = context;
    }

    public JmAroundScript deleteScript(EntityRef<? extends JmAroundScript> reference) {
        JmAroundScript deleted = (JmAroundScript)this.scripts.delete(reference);
        logger.info("script deleted: " + deleted);
        this.context.getEventBroker().fireEvent(new StoredEvent(this.scripts, (Entity)deleted, null));
        return deleted;
    }

    public JmAroundScript getAroundScriptFor(EntityRef<? extends DbObject> reference) {
        Validate.notNull(reference);
        for (JmAroundScript aroundScript : this.scripts.getEntitiesAsSet()) {
            if (!reference.equals(aroundScript.getCoreModelRef())) continue;
            return aroundScript;
        }
        return null;
    }

    public Collection<? extends JmAroundScript> getAroundScripts() {
        return this.scripts.getEntitiesAsSet();
    }

    public Set<? extends Entity> getEntities() {
        return this.scripts.getEntitiesAsSet();
    }

    public JiemamyNamespace[] getNamespaces() {
        return SqlNamespace.values();
    }

    public OnMemoryEntityResolver<?> getResolver() {
        return this.scripts;
    }

    public URL getSchema() {
        return SqlFacet.class.getResource("/jiemamy-sql.xsd");
    }

    public JmAroundScript getUniversalAroundScript() {
        if (this.universalAroundScript == null) {
            return null;
        }
        return this.universalAroundScript.clone();
    }

    public void prepareStaxHandlers(StaxDirector director) {
        Validate.notNull((Object)director);
        director.addHandler(SqlFacet.class, (JiemamyQName)SqlQName.SQLS, (StaxHandler)new SqlFacetStaxHandler(director));
        director.addHandler(SimpleJmAroundScript.class, (JiemamyQName)SqlQName.AROUND_SCRIPT, (StaxHandler)new SimpleJmAroundScriptStaxHandler(director));
    }

    public <T extends Entity> T resolve(EntityRef<T> reference) {
        return (T)this.scripts.resolve(reference);
    }

    public Entity resolve(UUID id) {
        return this.scripts.resolve(id);
    }

    public void setUniversalAroundScript(JmAroundScript universalAroundScript) {
        this.universalAroundScript = universalAroundScript == null ? null : universalAroundScript.clone();
    }

    public void store(JmAroundScript script) {
        Validate.notNull((Object)script);
        JmAroundScript old = (JmAroundScript)this.scripts.store((Entity)script);
        if (old == null) {
            logger.debug((Marker)LogMarker.LIFECYCLE, "script stored: " + script);
        } else {
            logger.debug((Marker)LogMarker.LIFECYCLE, "script updated: (old) " + old);
            logger.debug((Marker)LogMarker.LIFECYCLE, "                (new) " + script);
        }
        this.context.getEventBroker().fireEvent(new StoredEvent(this.scripts, (Entity)old, (Entity)script));
    }
}

