/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JmMetadata;
import org.jiemamy.SqlFacet;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dialect.DefaultTokenResolver;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.EmitConfig;
import org.jiemamy.dialect.SqlEmitter;
import org.jiemamy.dialect.TokenResolver;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.column.ColumnParameterKey;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmCheckConstraint;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.JmDeferrability;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.JmNotNullConstraint;
import org.jiemamy.model.constraint.JmPrimaryKeyConstraint;
import org.jiemamy.model.constraint.JmUniqueKeyConstraint;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.LiteralType;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.index.JmIndex;
import org.jiemamy.model.index.JmIndexColumn;
import org.jiemamy.model.parameter.ParameterKey;
import org.jiemamy.model.script.JmAroundScript;
import org.jiemamy.model.script.Position;
import org.jiemamy.model.sql.Identifier;
import org.jiemamy.model.sql.Keyword;
import org.jiemamy.model.sql.Literal;
import org.jiemamy.model.sql.Separator;
import org.jiemamy.model.sql.SimpleSqlStatement;
import org.jiemamy.model.sql.SqlStatement;
import org.jiemamy.model.sql.Token;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.model.view.JmView;
import org.jiemamy.script.ScriptException;
import org.jiemamy.script.ScriptString;
import org.jiemamy.utils.ConstraintComparator;
import org.jiemamy.utils.DbObjectDependencyCalculator;
import org.jiemamy.utils.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSqlEmitter
implements SqlEmitter {
    private final TokenResolver tokenResolver;
    private static Logger logger = LoggerFactory.getLogger(DefaultSqlEmitter.class);

    public DefaultSqlEmitter(Dialect dialect) {
        this(dialect, new DefaultTokenResolver());
    }

    protected DefaultSqlEmitter(Dialect dialect, TokenResolver tokenResolver) {
        Validate.notNull((Object)dialect);
        Validate.notNull((Object)tokenResolver);
        this.tokenResolver = tokenResolver;
    }

    public List<SqlStatement> emit(JiemamyContext context, EmitConfig config) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)config);
        Validate.isTrue((boolean)context.hasFacet(SqlFacet.class));
        ArrayList result = Lists.newArrayList();
        this.emitScript(context, Position.BEGIN, result);
        JmMetadata metadata = context.getMetadata();
        if (metadata != null && !StringUtils.isEmpty((String)metadata.getSchemaName()) && config.emitCreateSchemaStatement()) {
            if (config.emitDropStatements()) {
                result.add(this.emitDropSchemaStatement(metadata.getSchemaName()));
            }
            result.add(this.emitCreateSchemaStatement(metadata.getSchemaName()));
        }
        if (config.emitDropStatements()) {
            List dropList = DbObjectDependencyCalculator.getSortedEntityList((JiemamyContext)context);
            ListUtil.reverse((List)dropList);
            for (DbObject dbObject : dropList) {
                result.add(this.emitDropDbObjectStatement(dbObject));
            }
        }
        for (DbObject dbObject : DbObjectDependencyCalculator.getSortedEntityList((JiemamyContext)context)) {
            Boolean disabled = (Boolean)dbObject.getParam(ParameterKey.DISABLED);
            if (disabled != null && disabled.booleanValue()) continue;
            this.emitScript(context, dbObject, Position.BEGIN, result);
            result.add(this.emitCreateDbObjectStatement(context, dbObject));
            this.emitScript(context, dbObject, Position.END, result);
        }
        int dataSetIndex = config.getDataSetIndex();
        if (dataSetIndex >= 0 && dataSetIndex < context.getDataSets().size()) {
            JmDataSet dataSet = (JmDataSet)context.getDataSets().get(dataSetIndex);
            result.add(new SimpleSqlStatement(Keyword.of("BEGIN"), Separator.SEMICOLON));
            for (DbObject dbObject : DbObjectDependencyCalculator.getSortedEntityList((JiemamyContext)context)) {
                Boolean disabled = (Boolean)dbObject.getParam(ParameterKey.DISABLED);
                if (disabled != null && disabled.booleanValue() || !(dbObject instanceof JmTable)) continue;
                JmTable table = (JmTable)dbObject;
                List records = (List)dataSet.getRecords().get(table.toReference());
                if (records == null) continue;
                for (JmRecord record : records) {
                    result.add(this.emitInsertStatement(context, table, record));
                }
            }
            result.add(new SimpleSqlStatement(Keyword.of("COMMIT"), Separator.SEMICOLON));
        }
        this.emitScript(context, Position.END, result);
        return result;
    }

    protected List<Token> emitColumn(JiemamyContext context, JmTable table, JmColumn column, TokenResolver tokenResolver) {
        JmNotNullConstraint nn;
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Identifier.of(column.getName()));
        tokens.addAll(tokenResolver.resolve(column.getDataType()));
        if (!StringUtils.isEmpty((String)column.getDefaultValue())) {
            RawTypeCategory category = column.getDataType().getRawTypeDescriptor().getCategory();
            tokens.add(Keyword.DEFAULT);
            tokens.add(Literal.of(column.getDefaultValue(), category.getLiteralType()));
        }
        if ((nn = table.getNotNullConstraintFor(column.toReference())) != null) {
            if (!StringUtils.isEmpty((String)nn.getName())) {
                tokens.add(Keyword.CONSTRAINT);
                tokens.add(Identifier.of(nn.getName()));
            }
            tokens.add(Keyword.NOT);
            tokens.add(Keyword.NULL);
        }
        return tokens;
    }

    protected SqlStatement emitCreateDbObjectStatement(JiemamyContext context, DbObject dbObject) {
        Validate.notNull((Object)dbObject);
        DbObjectEmitStrategy strategy = DbObjectEmitStrategy.fromDbObject(dbObject);
        if (strategy == null) {
            logger.warn("strategy for {} is not found.", (Object)dbObject.getClass().getName());
            return new SimpleSqlStatement(Keyword.of("-- " + dbObject.toString()), new Token[0]);
        }
        return strategy.emit(context, dbObject, this, this.tokenResolver);
    }

    protected SqlStatement emitCreateIndexStatement(JiemamyContext context, JmTable table, JmIndex index) {
        Validate.notNull((Object)table);
        Validate.notNull((Object)index);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.CREATE);
        if (index.isUnique()) {
            tokens.add(Keyword.UNIQUE);
        }
        tokens.add(Keyword.INDEX);
        tokens.add(Identifier.of(index.getName()));
        tokens.add(Keyword.ON);
        tokens.add(Identifier.of(table.getName()));
        tokens.add(Separator.LEFT_PAREN);
        List indexColumns = index.getIndexColumns();
        for (JmIndexColumn indexColumn : indexColumns) {
            tokens.addAll(this.emitIndexColumnClause(context, indexColumn));
            tokens.add(Separator.COMMA);
        }
        if (!index.getIndexColumns().isEmpty()) {
            tokens.remove(tokens.size() - 1);
        }
        tokens.add(Separator.RIGHT_PAREN);
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    protected SqlStatement emitCreateSchemaStatement(String schemaName) {
        Validate.notNull((Object)schemaName);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.CREATE);
        tokens.add(Keyword.SCHEMA);
        tokens.add(Identifier.of(schemaName));
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    protected SqlStatement emitDropDbObjectStatement(DbObject dbObject) {
        Validate.notNull((Object)dbObject);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.DROP);
        tokens.addAll(this.tokenResolver.resolve(dbObject));
        tokens.add(Identifier.of(dbObject.getName()));
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    protected SqlStatement emitDropIndexStatement(JmIndex index) {
        Validate.notNull((Object)index);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.DROP);
        tokens.add(Keyword.INDEX);
        tokens.add(Identifier.of(index.getName()));
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    protected SqlStatement emitDropSchemaStatement(String schemaName) {
        Validate.notNull((Object)schemaName);
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.DROP);
        tokens.add(Keyword.SCHEMA);
        tokens.add(Identifier.of(schemaName));
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    protected List<Token> emitIndexColumnClause(JiemamyContext context, JmIndexColumn indexColumn) {
        Validate.notNull((Object)context);
        Validate.notNull((Object)indexColumn);
        ArrayList tokens = Lists.newArrayList();
        EntityRef columnRef = indexColumn.getColumnRef();
        JmColumn column = (JmColumn)context.resolve(columnRef);
        tokens.add(Identifier.of(column.getName()));
        JmIndexColumn.SortOrder sortOrder = indexColumn.getSortOrder();
        tokens.addAll(this.tokenResolver.resolve(sortOrder));
        return tokens;
    }

    protected SqlStatement emitInsertStatement(JiemamyContext context, JmTable table, JmRecord record) {
        ArrayList tokens = Lists.newArrayList();
        tokens.add(Keyword.INSERT);
        tokens.add(Keyword.INTO);
        tokens.add(Identifier.of(table.getName()));
        ArrayList columnList = Lists.newArrayList();
        ArrayList dataList = Lists.newArrayList();
        columnList.add(Separator.LEFT_PAREN);
        dataList.add(Separator.LEFT_PAREN);
        List columns = table.getColumns();
        int size = 0;
        for (JmColumn column : columns) {
            String value;
            if (!record.getValues().containsKey(column.toReference())) continue;
            DataType dataType = column.getDataType();
            try {
                ScriptString ss = (ScriptString)record.getValues().get(column.toReference());
                HashMap env = Maps.newHashMap();
                value = ss.process((Map)env);
            }
            catch (ClassNotFoundException e) {
                logger.error("", (Throwable)e);
                continue;
            }
            catch (ScriptException e) {
                logger.error("", (Throwable)e);
                continue;
            }
            Literal dataLiteral = value == null ? Literal.NULL : Literal.of(value, dataType.getRawTypeDescriptor().getCategory().getLiteralType());
            columnList.add(Identifier.of(column.getName()));
            columnList.add(Separator.COMMA);
            dataList.add(dataLiteral);
            dataList.add(Separator.COMMA);
            ++size;
        }
        if (size > 0) {
            columnList.remove(columnList.size() - 1);
            dataList.remove(dataList.size() - 1);
        }
        columnList.add(Separator.RIGHT_PAREN);
        dataList.add(Separator.RIGHT_PAREN);
        tokens.addAll(columnList);
        tokens.add(Keyword.VALUES);
        tokens.addAll(dataList);
        tokens.add(Separator.SEMICOLON);
        return new SimpleSqlStatement(tokens);
    }

    private void emitScript(JiemamyContext context, DbObject dbObject, Position position, List<SqlStatement> result) {
        SqlFacet facet = (SqlFacet)context.getFacet(SqlFacet.class);
        JmAroundScript aroundScript = facet.getAroundScriptFor((EntityRef<? extends DbObject>)dbObject.toReference());
        if (aroundScript == null) {
            return;
        }
        try {
            String beginScriptResilt = aroundScript.process(context, position, dbObject);
            if (!StringUtils.isEmpty((String)beginScriptResilt)) {
                result.add(new SimpleSqlStatement(Literal.of(beginScriptResilt, LiteralType.FRAGMENT), new Token[0]));
            }
        }
        catch (ClassNotFoundException e) {
            result.add(new SimpleSqlStatement(Literal.of("-- ERROR: Cannot resolve " + aroundScript.getScriptEngineClassName(position) + "\n", LiteralType.FRAGMENT), new Token[0]));
        }
        catch (ScriptException e) {
            result.add(new SimpleSqlStatement(Literal.of("-- ERROR: script execution failed " + aroundScript.getScriptEngineClassName(position) + "\n", LiteralType.FRAGMENT), new Token[0]));
        }
    }

    private void emitScript(JiemamyContext context, Position position, List<SqlStatement> result) {
        SqlFacet facet = (SqlFacet)context.getFacet(SqlFacet.class);
        JmAroundScript aroundScript = facet.getUniversalAroundScript();
        if (aroundScript == null) {
            return;
        }
        try {
            String beginScriptResilt = aroundScript.process(context, position, context);
            if (!StringUtils.isEmpty((String)beginScriptResilt)) {
                result.add(new SimpleSqlStatement(Literal.of(beginScriptResilt, LiteralType.FRAGMENT), new Token[0]));
            }
        }
        catch (ClassNotFoundException e) {
            result.add(new SimpleSqlStatement(Literal.of("-- ERROR: Cannot resolve " + aroundScript.getScriptEngineClassName(position) + "\n", LiteralType.FRAGMENT), new Token[0]));
        }
        catch (ScriptException e) {
            result.add(new SimpleSqlStatement(Literal.of("-- ERROR: script execution failed " + aroundScript.getScriptEngineClassName(position) + "\n", LiteralType.FRAGMENT), new Token[0]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DbObjectEmitStrategy {
        TABLE(JmTable.class){

            public SqlStatement emit(JiemamyContext context, DbObject dbObject, DefaultSqlEmitter sqlEmitter, TokenResolver tokenResolver) {
                assert (dbObject instanceof JmTable);
                JmTable table = (JmTable)dbObject;
                ArrayList tokens = Lists.newArrayList();
                tokens.add(Keyword.CREATE);
                tokens.add(Keyword.TABLE);
                tokens.add(Identifier.of(table.getName()));
                tokens.add(Separator.LEFT_PAREN);
                for (JmColumn column : table.getColumns()) {
                    Boolean disabled = (Boolean)column.getParam(ColumnParameterKey.DISABLED);
                    if (disabled != null && disabled.booleanValue()) continue;
                    List<Token> columnTokens = sqlEmitter.emitColumn(context, table, column, tokenResolver);
                    tokens.addAll(columnTokens);
                    tokens.add(Separator.COMMA);
                }
                ArrayList constraints = Lists.newArrayList((Iterable)table.getConstraints());
                Collections.sort(constraints, ConstraintComparator.INSTANCE);
                for (JmConstraint constraint : constraints) {
                    ConstraintEmitStrategy strategy = ConstraintEmitStrategy.fromAttribute(constraint);
                    if (strategy == null) continue;
                    List<Token> constraintTokens = strategy.emit(context, constraint, tokenResolver);
                    tokens.addAll(constraintTokens);
                    tokens.add(Separator.COMMA);
                }
                if (!table.getColumns().isEmpty() || !table.getConstraints().isEmpty()) {
                    tokens.remove(tokens.size() - 1);
                }
                tokens.add(Separator.RIGHT_PAREN);
                tokens.add(Separator.SEMICOLON);
                return new SimpleSqlStatement(tokens);
            }
        }
        ,
        VIEW(JmView.class){

            public SqlStatement emit(JiemamyContext context, DbObject dbObject, DefaultSqlEmitter defaultSqlEmitter, TokenResolver tokenResolver) {
                assert (dbObject instanceof JmView);
                JmView view = (JmView)dbObject;
                ArrayList tokens = Lists.newArrayList();
                tokens.add(Keyword.CREATE);
                tokens.add(Keyword.VIEW);
                tokens.add(Identifier.of(view.getName()));
                tokens.add(Keyword.AS);
                tokens.add(Literal.of(view.getDefinition(), LiteralType.FRAGMENT));
                tokens.add(Separator.SEMICOLON);
                return new SimpleSqlStatement(tokens);
            }
        };

        private final Class<? extends DbObject> clazz;

        public static DbObjectEmitStrategy fromDbObject(DbObject dbObject) {
            Validate.notNull((Object)dbObject);
            for (DbObjectEmitStrategy s : DbObjectEmitStrategy.values()) {
                if (s.clazz == dbObject.getClass()) {
                    return s;
                }
                for (Class<?> c : dbObject.getClass().getInterfaces()) {
                    if (s.clazz != c) continue;
                    return s;
                }
            }
            return null;
        }

        private DbObjectEmitStrategy(Class<? extends DbObject> clazz) {
            this.clazz = clazz;
        }

        public abstract SqlStatement emit(JiemamyContext var1, DbObject var2, DefaultSqlEmitter var3, TokenResolver var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ConstraintEmitStrategy {
        PK(JmPrimaryKeyConstraint.class){

            public List<Token> emit(JiemamyContext context, JmConstraint constraint, TokenResolver tokenResolver) {
                JmPrimaryKeyConstraint primaryKey = (JmPrimaryKeyConstraint)constraint;
                ArrayList tokens = Lists.newArrayList();
                ConstraintEmitStrategy.addConstraintNameDefinition((JmConstraint)primaryKey, tokens);
                tokens.add(Keyword.PRIMARY);
                tokens.add(Keyword.KEY);
                ConstraintEmitStrategy.addColumnList(context, tokens, primaryKey.getKeyColumns());
                return tokens;
            }
        }
        ,
        UK(JmUniqueKeyConstraint.class){

            public List<Token> emit(JiemamyContext context, JmConstraint constraint, TokenResolver tokenResolver) {
                JmUniqueKeyConstraint uniqueKey = (JmUniqueKeyConstraint)constraint;
                ArrayList tokens = Lists.newArrayList();
                ConstraintEmitStrategy.addConstraintNameDefinition((JmConstraint)uniqueKey, tokens);
                tokens.add(Keyword.UNIQUE);
                tokens.add(Keyword.KEY);
                ConstraintEmitStrategy.addColumnList(context, tokens, uniqueKey.getKeyColumns());
                return tokens;
            }
        }
        ,
        FK(JmForeignKeyConstraint.class){

            public List<Token> emit(JiemamyContext context, JmConstraint constraint, TokenResolver tokenResolver) {
                JmForeignKeyConstraint foreignKey = (JmForeignKeyConstraint)constraint;
                ArrayList tokens = Lists.newArrayList();
                ConstraintEmitStrategy.addConstraintNameDefinition((JmConstraint)foreignKey, tokens);
                tokens.add(Keyword.FOREIGN);
                tokens.add(Keyword.KEY);
                ConstraintEmitStrategy.addColumnList(context, tokens, foreignKey.getKeyColumns());
                tokens.add(Keyword.REFERENCES);
                JmTable referenceEntity = foreignKey.findReferenceTable((Iterable)context.getTables());
                tokens.add(Identifier.of(referenceEntity.getName()));
                ConstraintEmitStrategy.addColumnList(context, tokens, foreignKey.getReferenceColumns());
                if (foreignKey.getMatchType() != null) {
                    tokens.addAll(tokenResolver.resolve(foreignKey.getMatchType()));
                }
                if (foreignKey.getOnDelete() != null) {
                    tokens.add(Keyword.ON);
                    tokens.add(Keyword.DELETE);
                    tokens.addAll(tokenResolver.resolve(foreignKey.getOnDelete()));
                }
                if (foreignKey.getOnUpdate() != null) {
                    tokens.add(Keyword.ON);
                    tokens.add(Keyword.UPDATE);
                    tokens.addAll(tokenResolver.resolve(foreignKey.getOnUpdate()));
                }
                if (foreignKey.getDeferrability() != null) {
                    JmDeferrability deferrability = foreignKey.getDeferrability();
                    if (!deferrability.isDeferrable()) {
                        tokens.add(Keyword.NOT);
                    }
                    tokens.add(Keyword.DEFERRABLE);
                    if (deferrability.getInitiallyCheckTime() != null) {
                        tokens.addAll(tokenResolver.resolve(deferrability.getInitiallyCheckTime()));
                    }
                }
                return tokens;
            }
        }
        ,
        TABLE_CHECK(JmCheckConstraint.class){

            public List<Token> emit(JiemamyContext context, JmConstraint constraint, TokenResolver tokenResolver) {
                JmCheckConstraint checkConstraint = (JmCheckConstraint)constraint;
                ArrayList tokens = Lists.newArrayList();
                ConstraintEmitStrategy.addConstraintNameDefinition((JmConstraint)checkConstraint, tokens);
                tokens.add(Keyword.CHECK);
                tokens.add(Separator.LEFT_PAREN);
                tokens.add(Literal.of(checkConstraint.getExpression(), LiteralType.FRAGMENT));
                tokens.add(Separator.RIGHT_PAREN);
                return tokens;
            }
        };

        private final Class<? extends JmConstraint> clazz;

        public static ConstraintEmitStrategy fromAttribute(JmConstraint constraint) {
            for (ConstraintEmitStrategy strategy : ConstraintEmitStrategy.values()) {
                if (strategy.clazz == constraint.getClass()) {
                    return strategy;
                }
                for (Class<?> c : constraint.getClass().getInterfaces()) {
                    if (strategy.clazz != c) continue;
                    return strategy;
                }
            }
            return null;
        }

        private static void addColumnList(JiemamyContext context, List<Token> tokens, List<EntityRef<? extends JmColumn>> columnRefs) {
            tokens.add(Separator.LEFT_PAREN);
            for (EntityRef<? extends JmColumn> columnRef : columnRefs) {
                JmColumn column = (JmColumn)context.resolve(columnRef);
                tokens.add(Identifier.of(column.getName()));
                tokens.add(Separator.COMMA);
            }
            if (!columnRefs.isEmpty()) {
                tokens.remove(tokens.size() - 1);
            }
            tokens.add(Separator.RIGHT_PAREN);
        }

        private static void addConstraintNameDefinition(JmConstraint constraint, List<Token> tokens) {
            if (!StringUtils.isEmpty((String)constraint.getName())) {
                tokens.add(Keyword.CONSTRAINT);
                tokens.add(Identifier.of(constraint.getName()));
            }
        }

        private ConstraintEmitStrategy(Class<? extends JmConstraint> clazz) {
            this.clazz = clazz;
        }

        public abstract <T extends JmConstraint> List<Token> emit(JiemamyContext var1, T var2, TokenResolver var3);
    }
}

