/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.ForeignKeyImportVisitor;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.JmDeferrability;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.model.constraint.SimpleJmForeignKeyConstraint;
import org.jiemamy.model.table.SimpleJmTable;
import org.jiemamy.utils.sql.metadata.KeyMeta;
import org.jiemamy.utils.visitor.AbstractCollectionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultForeignKeyImportVisitor
extends AbstractCollectionVisitor<KeyMeta, Void, RuntimeException>
implements ForeignKeyImportVisitor {
    private JiemamyContext context;
    private Map<String, SimpleJmForeignKeyConstraint> importedForeignKeys = Maps.newHashMap();

    public DefaultForeignKeyImportVisitor(Dialect dialect) {
        Validate.notNull((Object)dialect);
    }

    @Override
    public void initialize(JiemamyContext context) {
        Validate.notNull((Object)context);
        this.context = context;
    }

    public Void visit(KeyMeta keys) {
        Validate.notNull((Object)keys);
        SimpleJmTable constrainedTable = (SimpleJmTable)this.context.getTable(keys.fkTableName);
        SimpleJmTable referenceTable = (SimpleJmTable)this.context.getTable(keys.pkTableName);
        if (constrainedTable != null && referenceTable != null) {
            SimpleJmForeignKeyConstraint foreignKey = this.importedForeignKeys.get(keys.fkName);
            if (foreignKey == null) {
                foreignKey = new SimpleJmForeignKeyConstraint();
                foreignKey.setName(keys.fkName);
                this.importedForeignKeys.put(keys.fkName, foreignKey);
            }
            JmColumn fkColumn = constrainedTable.getColumn(keys.fkColumnName);
            JmColumn pkColumn = referenceTable.getColumn(keys.pkColumnName);
            foreignKey.addReferencing(fkColumn.toReference(), pkColumn.toReference());
            if (keys.updateRule != null) {
                JmForeignKeyConstraint.ReferentialAction onUpdate = JmForeignKeyConstraint.ReferentialAction.valueOf((String)keys.updateRule.name());
                foreignKey.setOnUpdate(onUpdate);
            }
            if (keys.deleteRule != null) {
                JmForeignKeyConstraint.ReferentialAction onDelete = JmForeignKeyConstraint.ReferentialAction.valueOf((String)keys.deleteRule.name());
                foreignKey.setOnDelete(onDelete);
            }
            SimpleJmDeferrability deferrability = SimpleJmDeferrability.fromDeferrability((KeyMeta.Deferrability)keys.deferrability);
            foreignKey.setDeferrability((JmDeferrability)deferrability);
            constrainedTable.store((JmConstraint)foreignKey);
        }
        this.context.store((DbObject)constrainedTable);
        return null;
    }
}

