/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dialect.DatabaseMetadataParser;
import org.jiemamy.dialect.DatabaseReader;
import org.jiemamy.dialect.DbObjectImportVisitor;
import org.jiemamy.dialect.DefaultDbObjectImportVisitor;
import org.jiemamy.dialect.DefaultForeignKeyImportVisitor;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.ForeignKeyImportVisitor;
import org.jiemamy.dialect.ParseMetadataConfig;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.dataset.SimpleJmDataSet;
import org.jiemamy.model.dataset.SimpleJmRecord;
import org.jiemamy.model.table.SimpleJmTable;
import org.jiemamy.script.ScriptString;
import org.jiemamy.utils.DbObjectDependencyCalculator;
import org.jiemamy.utils.sql.SqlExecutor;
import org.jiemamy.utils.sql.SqlExecutorHandler;
import org.jiemamy.utils.sql.metadata.TypeSafeDatabaseMetaData;

public class DefaultDatabaseMetadataParser
implements DatabaseMetadataParser {
    private final DbObjectImportVisitor dbObjectImportVisitor;
    private final ForeignKeyImportVisitor foreignKeyImportVisitor;

    public DefaultDatabaseMetadataParser(Dialect dialect) {
        this(new DefaultDbObjectImportVisitor(dialect), new DefaultForeignKeyImportVisitor(dialect));
    }

    protected DefaultDatabaseMetadataParser(DbObjectImportVisitor dbObjectImportVisitor, ForeignKeyImportVisitor foreignKeyImportVisitor) {
        Validate.notNull((Object)dbObjectImportVisitor);
        Validate.notNull((Object)foreignKeyImportVisitor);
        this.dbObjectImportVisitor = dbObjectImportVisitor;
        this.foreignKeyImportVisitor = foreignKeyImportVisitor;
    }

    public void parseMetadata(JiemamyContext context, DatabaseMetaData meta, ParseMetadataConfig config) throws SQLException {
        Validate.notNull((Object)context);
        Validate.notNull((Object)meta);
        Validate.notNull((Object)config);
        Connection connection = meta.getConnection();
        TypeSafeDatabaseMetaData metaData = new TypeSafeDatabaseMetaData(meta);
        DatabaseReader reader = new DatabaseReader(this, config, meta);
        this.setUpRead(connection);
        this.dbObjectImportVisitor.intialize(metaData, context, config);
        reader.readEnities(this.dbObjectImportVisitor);
        this.foreignKeyImportVisitor.initialize(context);
        reader.readRelations(this.foreignKeyImportVisitor);
        if (config.isImportDataSet()) {
            List dbObjects = DbObjectDependencyCalculator.getSortedEntityList((JiemamyContext)context);
            ArrayList tables = Lists.newArrayList((Iterable)Iterables.filter((Iterable)dbObjects, SimpleJmTable.class));
            final SimpleJmDataSet dataSet = new SimpleJmDataSet();
            dataSet.setName("imported " + new Date().toString());
            SqlExecutor ex = new SqlExecutor(connection);
            for (final SimpleJmTable table : tables) {
                ex.execute("SELECT * FROM " + table.getName() + ";", new SqlExecutorHandler(){

                    public void handleResultSet(String sql, ResultSet rs) throws SQLException {
                        while (rs.next()) {
                            HashMap map = Maps.newHashMap();
                            for (JmColumn col : table.getColumns()) {
                                String data = rs.getString(col.getName());
                                map.put(col.toReference(), new ScriptString(data));
                            }
                            dataSet.addRecord(table.toReference(), (JmRecord)new SimpleJmRecord((Map)map));
                        }
                    }

                    public void handleUpdateCount(String sql, int count) {
                    }
                });
            }
            context.store((JmDataSet)dataSet);
        }
        this.tearDownRead(connection);
    }

    protected void setUpRead(Connection connection) {
    }

    protected void tearDownRead(Connection connection) {
    }
}

