/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.out.SMNamespace;
import org.jiemamy.SqlFacet;
import org.jiemamy.model.script.JmAroundScript;
import org.jiemamy.serializer.EntityComparator;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.JiemamyQName;
import org.jiemamy.xml.SqlNamespace;
import org.jiemamy.xml.SqlQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SqlFacetStaxHandler
extends StaxHandler<SqlFacet> {
    private static Logger logger = LoggerFactory.getLogger(SqlFacetStaxHandler.class);

    public SqlFacetStaxHandler(StaxDirector director) {
        super(director);
    }

    public SqlFacet handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName((JiemamyQName)SqlQName.SQLS));
            Validate.notNull((Object)dctx.getContext());
            Validate.isTrue((boolean)dctx.getContext().hasFacet(SqlFacet.class));
            SqlFacet facet = (SqlFacet)dctx.getContext().getFacet(SqlFacet.class);
            JiemamyCursor cursor = dctx.peek();
            JiemamyCursor diagramsCursor = cursor.childElementCursor();
            while (diagramsCursor.getNext() != null) {
                dctx.push(diagramsCursor);
                JmAroundScript aroundScript = (JmAroundScript)this.getDirector().direct(dctx);
                if (aroundScript != null) {
                    facet.store(aroundScript);
                } else {
                    logger.warn("null aroundScript");
                }
                dctx.pop();
            }
            return facet;
        }
        catch (XMLStreamException e) {
            throw new SerializationException((Throwable)e);
        }
    }

    public void handleSerialization(SqlFacet model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement((JiemamyQName)SqlQName.SQLS);
            SMNamespace xsiNs = element.getSMOutputElement().getNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            element.addAttribute(xsiNs, "schemaLocation", this.getSchemaLocationDefinition(SqlNamespace.values()));
            sctx.push((JiemamyOutputContainer)element);
            ArrayList list = Lists.newArrayList(model.getAroundScripts());
            Collections.sort(list, EntityComparator.INSTANCE);
            for (JmAroundScript aroundScript : list) {
                this.getDirector().direct((Object)aroundScript, sctx);
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException((Throwable)e);
        }
    }
}

