/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator;

import java.util.Locale;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;

public interface Problem {
    public boolean canQuickFix();

    public String getErrorCode();

    public String getMessage();

    public String getMessage(Locale var1);

    public Severity getSeverity();

    public UUID getTargetId();

    public void quickFix(JiemamyContext var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        FATAL(5),
        ERROR(4),
        WARN(3),
        NOTICE(2),
        INFO(1);

        private final int value;

        public static Severity fromErrorCode(String code) {
            Validate.notNull((Object)code);
            for (Severity severity : Severity.values()) {
                if (!code.startsWith(Character.toString(severity.name().charAt(0)))) continue;
                return severity;
            }
            return null;
        }

        private Severity(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

