/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.dataset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.dddbase.AbstractOrderedEntity;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.utils.CloneUtil;
import org.jiemamy.dddbase.utils.MutationMonitor;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.model.dataset.JmRecord;
import org.jiemamy.model.table.JmTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmDataSet
extends AbstractOrderedEntity
implements JmDataSet {
    private String name;
    private Map<EntityRef<? extends JmTable>, List<JmRecord>> records = Maps.newHashMap();

    public SimpleJmDataSet() {
        this(UUID.randomUUID());
    }

    public SimpleJmDataSet(UUID id) {
        super(id);
    }

    public synchronized void addRecord(EntityRef<? extends JmTable> tableRef, JmRecord record) {
        Validate.notNull(tableRef);
        Validate.notNull((Object)record);
        if (!this.records.containsKey(tableRef)) {
            this.records.put(tableRef, new ArrayList());
        }
        this.records.get(tableRef).add(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SimpleJmDataSet clone() {
        SimpleJmDataSet clone = (SimpleJmDataSet)super.clone();
        HashMap cloneMap = Maps.newHashMapWithExpectedSize((int)this.records.size());
        for (Map.Entry<EntityRef<? extends JmTable>, List<JmRecord>> entry : this.records.entrySet()) {
            List<JmRecord> value = entry.getValue();
            cloneMap.put(entry.getKey(), CloneUtil.cloneValueArrayList(value));
        }
        SimpleJmDataSet simpleJmDataSet = clone;
        synchronized (simpleJmDataSet) {
            clone.records = cloneMap;
        }
        return clone;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized List<JmRecord> getRecord(EntityRef<? extends JmTable> tableRef) {
        Validate.notNull(tableRef);
        return this.records.get(tableRef);
    }

    @Override
    public synchronized Map<EntityRef<? extends JmTable>, List<JmRecord>> getRecords() {
        return MutationMonitor.monitor((Map)Maps.newHashMap(this.records));
    }

    public synchronized void putRecord(EntityRef<? extends JmTable> tableRef, List<JmRecord> records) {
        Validate.notNull(tableRef);
        Validate.noNullElements(records);
        this.records.put(tableRef, Lists.newArrayList(records));
    }

    public synchronized void removeRecord(EntityRef<? extends JmTable> tableRef) {
        Validate.notNull(tableRef);
        this.records.remove(tableRef);
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityRef<? extends SimpleJmDataSet> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

