/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.model.constraint.SimpleJmNotNullConstraint;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmNotNullConstraintStaxHandler
extends StaxHandler<SimpleJmNotNullConstraint> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmNotNullConstraintStaxHandler.class);

    public SimpleJmNotNullConstraintStaxHandler(StaxDirector director) {
        super(director);
    }

    @Override
    public SimpleJmNotNullConstraint handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.NOT_NULL));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmNotNullConstraint notNull = new SimpleJmNotNullConstraint(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.NAME)) {
                        notNull.setName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                        notNull.setLogicalName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        notNull.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DEFERRABILITY)) {
                        SimpleJmDeferrability deferrability = (SimpleJmDeferrability)this.getDirector().direct(dctx);
                        notNull.setDeferrability(deferrability);
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.COLUMN_REF)) {
                        String strReferentId = childCursor.getAttrValue(CoreQName.REF);
                        assert (strReferentId != null);
                        UUID referentId = dctx.getContext().toUUID(strReferentId);
                        DefaultEntityRef columnRef = DefaultEntityRef.of((UUID)referentId);
                        notNull.setColumn((EntityRef<? extends JmColumn>)columnRef);
                        continue;
                    }
                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return notNull;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmNotNullConstraint model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.NOT_NULL);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            sctx.push(element);
            if (model.getDeferrability() != null) {
                this.getDirector().direct(model.getDeferrability(), sctx);
            }
            sctx.pop();
            JiemamyOutputElement colRefElement = element.addElement(CoreQName.COLUMN_REF);
            EntityRef<? extends JmColumn> colRef = model.getColumn();
            if (colRef != null) {
                colRefElement.addAttribute((JiemamyQName)CoreQName.REF, colRef.getReferentId());
            } else {
                logger.warn("NotNullConstraint target is null.");
            }
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

