/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.SimpleJmMetadata;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmMetadataStaxHandler
extends StaxHandler<SimpleJmMetadata> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmMetadataStaxHandler.class);

    public SimpleJmMetadataStaxHandler(StaxDirector director) {
        super(director);
    }

    @Override
    public SimpleJmMetadata handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.META));
            JiemamyCursor cursor = dctx.peek();
            SimpleJmMetadata model = new SimpleJmMetadata();
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.DIALECT)) {
                        model.setDialectClassName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.SCHEMA_NAME)) {
                        model.setSchemaName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        model.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    this.getDirector().direct(dctx);
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return model;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmMetadata model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.META);
            element.addElementAndCharacters((JiemamyQName)CoreQName.DIALECT, model.getDialectClassName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.SCHEMA_NAME, model.getSchemaName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

