/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.validator.CannotFixException;
import org.jiemamy.validator.Problem;

public abstract class AbstractProblem
implements Problem {
    static final String BUNDLE_NAME = "org/jiemamy/validator/ErrorMessages";
    private Object[] arguments = ArrayUtils.EMPTY_OBJECT_ARRAY;
    private final String errorCode;
    private final String baseName;
    private final UUID targetId;

    public AbstractProblem(Entity target, String errorCode) {
        this(target, errorCode, BUNDLE_NAME, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public AbstractProblem(Entity target, String errorCode, Object[] arguments) {
        this(target, errorCode, BUNDLE_NAME, arguments);
    }

    AbstractProblem(Entity target, String errorCode, String baseName, Object[] arguments) {
        Validate.notNull((Object)errorCode);
        Validate.notNull((Object)baseName);
        this.targetId = target == null ? null : target.getId();
        this.errorCode = errorCode;
        this.baseName = baseName;
        this.arguments = arguments;
    }

    public boolean canQuickFix() {
        return false;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public String getMessage(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, locale);
        return MessageFormat.format(bundle.getString(this.errorCode), this.arguments);
    }

    public Problem.Severity getSeverity() {
        return Problem.Severity.fromErrorCode(this.errorCode);
    }

    public UUID getTargetId() {
        return this.targetId;
    }

    public void quickFix(JiemamyContext context) {
        throw new CannotFixException();
    }

    public String toString() {
        return this.errorCode + " " + this.getMessage();
    }
}

