/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.serializer.stax;

import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang.Validate;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.staxmate.in.ElementInfoFactory;
import org.codehaus.staxmate.in.SMElementInfo;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.in.SMFilter;
import org.codehaus.staxmate.in.SMInputCursor;
import org.jiemamy.xml.JiemamyQName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiemamyCursor {
    final SMInputCursor cursor;

    public JiemamyCursor(SMInputCursor cursor) {
        Validate.notNull((Object)cursor);
        this.cursor = cursor;
    }

    public final JiemamyCursor advance() throws XMLStreamException {
        this.cursor.advance();
        return this;
    }

    public XMLEvent asEvent() throws XMLStreamException {
        return this.cursor.asEvent();
    }

    public final JiemamyCursor childCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childCursor());
    }

    public JiemamyCursor childCursor(SMFilter f) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childCursor(f));
    }

    public final JiemamyCursor childElementCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childElementCursor());
    }

    public final JiemamyCursor childElementCursor(JiemamyQName elemName) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childElementCursor(elemName.getQName()));
    }

    public final JiemamyCursor childElementCursor(String elemLocalName) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childElementCursor(elemLocalName));
    }

    public final JiemamyCursor childMixedCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.childMixedCursor());
    }

    public final String collectDescendantText() throws XMLStreamException {
        return this.cursor.collectDescendantText();
    }

    public String collectDescendantText(boolean includeIgnorable) {
        try {
            return this.cursor.collectDescendantText(includeIgnorable);
        }
        catch (XMLStreamException xMLStreamException) {
            return null;
        }
    }

    public XMLStreamException constructStreamException(String msg) {
        return this.cursor.constructStreamException(msg);
    }

    public final JiemamyCursor descendantCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantCursor());
    }

    public JiemamyCursor descendantCursor(SMFilter f) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantCursor(f));
    }

    public final JiemamyCursor descendantElementCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantElementCursor());
    }

    public final JiemamyCursor descendantElementCursor(QName elemName) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantElementCursor(elemName));
    }

    public final JiemamyCursor descendantElementCursor(String elemLocalName) throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantElementCursor(elemLocalName));
    }

    public final JiemamyCursor descendantMixedCursor() throws XMLStreamException {
        return new JiemamyCursor(this.cursor.descendantMixedCursor());
    }

    public int findAttrIndex(String uri, String localName) throws XMLStreamException {
        return this.cursor.findAttrIndex(uri, localName);
    }

    public boolean getAttrBooleanValue(int index) throws XMLStreamException {
        return this.cursor.getAttrBooleanValue(index);
    }

    public boolean getAttrBooleanValue(int index, boolean defValue) throws XMLStreamException {
        return this.cursor.getAttrBooleanValue(index, defValue);
    }

    public int getAttrCount() throws XMLStreamException {
        return this.cursor.getAttrCount();
    }

    public double getAttrDoubleValue(int index) throws XMLStreamException {
        return this.cursor.getAttrDoubleValue(index);
    }

    public double getAttrDoubleValue(int index, double defValue) throws XMLStreamException {
        return this.cursor.getAttrDoubleValue(index, defValue);
    }

    public <T extends Enum<T>> T getAttrEnumValue(int index, Class<T> enumType) throws XMLStreamException {
        return (T)this.cursor.getAttrEnumValue(index, enumType);
    }

    public <T extends Enum<T>> T getAttrEnumValue(JiemamyQName jQName, Class<T> enumType) throws XMLStreamException {
        int index = this.cursor.findAttrIndex(jQName.getQName().getNamespaceURI(), jQName.getQName().getLocalPart());
        return (T)this.cursor.getAttrEnumValue(index, enumType);
    }

    public int getAttrIntValue(int index) throws XMLStreamException {
        return this.cursor.getAttrIntValue(index);
    }

    public int getAttrIntValue(int index, int defValue) throws XMLStreamException {
        return this.cursor.getAttrIntValue(index, defValue);
    }

    public int getAttrIntValue(JiemamyQName jQName) throws XMLStreamException {
        int index = this.cursor.findAttrIndex(jQName.getQName().getNamespaceURI(), jQName.getQName().getLocalPart());
        return this.cursor.getAttrIntValue(index);
    }

    public String getAttrLocalName(int index) throws XMLStreamException {
        return this.cursor.getAttrLocalName(index);
    }

    public long getAttrLongValue(int index) throws XMLStreamException {
        return this.cursor.getAttrLongValue(index);
    }

    public long getAttrLongValue(int index, long defValue) throws XMLStreamException {
        return this.cursor.getAttrLongValue(index, defValue);
    }

    public QName getAttrName(int index) throws XMLStreamException {
        return this.cursor.getAttrName(index);
    }

    public String getAttrNsUri(int index) throws XMLStreamException {
        return this.cursor.getAttrNsUri(index);
    }

    public String getAttrPrefix(int index) throws XMLStreamException {
        return this.cursor.getAttrPrefix(index);
    }

    public String getAttrValue(int index) throws XMLStreamException {
        return this.cursor.getAttrValue(index);
    }

    public String getAttrValue(JiemamyQName jQName) throws XMLStreamException {
        int index = this.cursor.findAttrIndex(jQName.getQName().getNamespaceURI(), jQName.getQName().getLocalPart());
        if (index == -1) {
            throw new IllegalArgumentException("attribute not found: " + jQName);
        }
        return this.cursor.getAttrValue(index);
    }

    public String getAttrValue(String localName) throws XMLStreamException {
        return this.cursor.getAttrValue(localName);
    }

    public String getAttrValue(String namespaceURI, String localName) throws XMLStreamException {
        return this.cursor.getAttrValue(namespaceURI, localName);
    }

    public SMEvent getCurrEvent() {
        return this.cursor.getCurrEvent();
    }

    public int getCurrEventCode() {
        return this.cursor.getCurrEventCode();
    }

    public Location getCursorLocation() throws XMLStreamException {
        return this.cursor.getCursorLocation();
    }

    public Object getData() {
        return this.cursor.getData();
    }

    public boolean getElemBooleanValue() throws XMLStreamException {
        return this.cursor.getElemBooleanValue();
    }

    public boolean getElemBooleanValue(boolean defValue) throws XMLStreamException {
        return this.cursor.getElemBooleanValue(defValue);
    }

    public double getElemDoubleValue() throws XMLStreamException {
        return this.cursor.getElemDoubleValue();
    }

    public double getElemDoubleValue(double defValue) throws XMLStreamException {
        return this.cursor.getElemDoubleValue(defValue);
    }

    public int getElementCount() {
        return this.cursor.getElementCount();
    }

    public final ElementInfoFactory getElementInfoFactory() {
        return this.cursor.getElementInfoFactory();
    }

    public final SMInputCursor.Tracking getElementTracking() {
        return this.cursor.getElementTracking();
    }

    public <T extends Enum<T>> T getElemEnumValue(Class<T> enumType) throws XMLStreamException {
        return (T)this.cursor.getElemEnumValue(enumType);
    }

    public int getElemIntValue() throws XMLStreamException {
        return this.cursor.getElemIntValue();
    }

    public int getElemIntValue(int defValue) throws XMLStreamException {
        return this.cursor.getElemIntValue(defValue);
    }

    public long getElemLongValue() throws XMLStreamException {
        return this.cursor.getElemLongValue();
    }

    public long getElemLongValue(long defValue) throws XMLStreamException {
        return this.cursor.getElemLongValue(defValue);
    }

    public String getElemStringValue() throws XMLStreamException {
        return this.cursor.getElemStringValue();
    }

    public String getLocalName() throws XMLStreamException {
        return this.cursor.getLocalName();
    }

    public SMEvent getNext() throws XMLStreamException {
        return this.cursor.getNext();
    }

    public int getNodeCount() {
        return this.cursor.getNodeCount();
    }

    public String getNsUri() throws XMLStreamException {
        return this.cursor.getNsUri();
    }

    public int getParentCount() {
        return this.cursor.getParentCount();
    }

    public SMElementInfo getParentTrackedElement() {
        return this.cursor.getParentTrackedElement();
    }

    public String getPathDesc() {
        return this.cursor.getPathDesc();
    }

    public String getPrefix() throws XMLStreamException {
        return this.cursor.getPrefix();
    }

    public String getPrefixedName() throws XMLStreamException {
        return this.cursor.getPrefixedName();
    }

    public QName getQName() throws XMLStreamException {
        return this.cursor.getQName();
    }

    public Location getStreamLocation() {
        return this.cursor.getStreamLocation();
    }

    public final XMLStreamReader2 getStreamReader() {
        return this.cursor.getStreamReader();
    }

    public String getText() throws XMLStreamException {
        return this.cursor.getText();
    }

    public SMElementInfo getTrackedElement() {
        return this.cursor.getTrackedElement();
    }

    public boolean hasAttr(JiemamyQName jQName) throws XMLStreamException {
        return -1 != this.cursor.findAttrIndex(jQName.getQName().getNamespaceURI(), jQName.getQName().getLocalPart());
    }

    public boolean hasLocalName(String expName) throws XMLStreamException {
        return this.cursor.hasLocalName(expName);
    }

    public boolean hasName(JiemamyQName jQName) throws XMLStreamException {
        return this.cursor.hasName(jQName.getQName());
    }

    public boolean hasName(String expNsURI, String expLN) throws XMLStreamException {
        return this.cursor.hasName(expNsURI, expLN);
    }

    public boolean isQName(JiemamyQName jQName) throws XMLStreamException {
        return this.cursor.getQName().equals(jQName.getQName());
    }

    public final boolean isRootCursor() {
        return this.cursor.isRootCursor();
    }

    public void processDescendantText(Writer w, boolean includeIgnorable) throws IOException, XMLStreamException {
        this.cursor.processDescendantText(w, includeIgnorable);
    }

    public final boolean readerAccessible() {
        return this.cursor.readerAccessible();
    }

    public void setData(Object o) {
        this.cursor.setData(o);
    }

    public final void setElementInfoFactory(ElementInfoFactory f) {
        this.cursor.setElementInfoFactory(f);
    }

    public final void setElementTracking(SMInputCursor.Tracking tracking) {
        this.cursor.setElementTracking(tracking);
    }

    public final void setFilter(SMFilter f) {
        this.cursor.setFilter(f);
    }

    public void throwStreamException(String msg) throws XMLStreamException {
        this.cursor.throwStreamException(msg);
    }

    public String toString() {
        return this.cursor.toString();
    }
}

