/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class ProcedureMeta {
    public final String procedureCat;
    public final String procedureSchem;
    public final String procedureName;
    public final String remarks;
    public final ProcedureType procedureType;

    public ProcedureMeta(ResultSet procedure) {
        Validate.notNull((Object)procedure);
        this.procedureCat = ResultSetUtil.getValue(String.class, procedure, "PROCEDURE_CAT", null);
        this.procedureSchem = ResultSetUtil.getValue(String.class, procedure, "PROCEDURE_SCHEM", null);
        this.procedureName = ResultSetUtil.getValue(String.class, procedure, "PROCEDURE_NAME", null);
        this.remarks = ResultSetUtil.getValue(String.class, procedure, "REMARKS", null);
        this.procedureType = ProcedureType.getProcedureType(ResultSetUtil.getValue(Short.TYPE, procedure, "PROCEDURE_TYPE", Short.valueOf((short)0)));
        assert (this.procedureName != null);
        assert (this.procedureType != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcedureType {
        RESULT_UNKNOWN(0),
        NO_RESULT(1),
        RETURNS_RESULT(2);

        private int value;

        private static ProcedureType getProcedureType(short value) {
            for (ProcedureType procedureType : ProcedureType.values()) {
                if (procedureType.value != value) continue;
                return procedureType;
            }
            return null;
        }

        private ProcedureType(int value) {
            this.value = value;
        }
    }
}

