/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class ColumnMeta {
    public final int sqlDataType;
    public final int sqlDatetimeSub;
    public final String tableCat;
    public final String tableSchem;
    public final String tableName;
    public final String columnName;
    public final int dataType;
    public final String typeName;
    public final int columnSize;
    public final int bufferLength;
    public final int decimalDigits;
    public final int numPrecRadix;
    public final Nullable nullable;
    public final String remarks;
    public final String columnDef;
    public final int charOctetLength;
    public final int ordinalPosition;
    public final IsNullable isNullable;
    public final String scopeCatalog;
    public final String scopeSchema;
    public final String scopeTable;
    public final short sourceDataType;

    public ColumnMeta(ResultSet column) {
        Validate.notNull((Object)column);
        this.tableCat = ResultSetUtil.getValue(String.class, column, "TABLE_CAT", null);
        this.tableSchem = ResultSetUtil.getValue(String.class, column, "TABLE_SCHEM", null);
        this.tableName = ResultSetUtil.getValue(String.class, column, "TABLE_NAME", null);
        this.columnName = ResultSetUtil.getValue(String.class, column, "COLUMN_NAME", null);
        this.dataType = ResultSetUtil.getValue(Integer.TYPE, column, "DATA_TYPE", Integer.valueOf(0));
        this.typeName = ResultSetUtil.getValue(String.class, column, "TYPE_NAME", null);
        this.columnSize = ResultSetUtil.getValue(Integer.TYPE, column, "COLUMN_SIZE", Integer.valueOf(0));
        this.bufferLength = ResultSetUtil.getValue(Integer.TYPE, column, "BUFFER_LENGTH", Integer.valueOf(0));
        this.decimalDigits = ResultSetUtil.getValue(Integer.TYPE, column, "DECIMAL_DIGITS", Integer.valueOf(0));
        this.numPrecRadix = ResultSetUtil.getValue(Integer.TYPE, column, "NUM_PREC_RADIX", Integer.valueOf(0));
        this.nullable = Nullable.getNullable(ResultSetUtil.getValue(Short.TYPE, column, "NULLABLE", Short.valueOf((short)0)));
        this.remarks = ResultSetUtil.getValue(String.class, column, "REMARKS", null);
        this.columnDef = ResultSetUtil.getValue(String.class, column, "COLUMN_DEF", null);
        this.sqlDataType = ResultSetUtil.getValue(Integer.TYPE, column, "SQL_DATA_TYPE", Integer.valueOf(0));
        this.sqlDatetimeSub = ResultSetUtil.getValue(Integer.TYPE, column, "SQL_DATETIME_SUB", Integer.valueOf(0));
        this.charOctetLength = ResultSetUtil.getValue(Integer.TYPE, column, "CHAR_OCTET_LENGTH", Integer.valueOf(0));
        this.ordinalPosition = ResultSetUtil.getValue(Integer.TYPE, column, "ORDINAL_POSITION", Integer.valueOf(0));
        this.isNullable = IsNullable.getIsNullable(ResultSetUtil.getValue(String.class, column, "IS_NULLABLE", null));
        this.scopeCatalog = ResultSetUtil.getValue(String.class, column, "SCOPE_CATLOG", null);
        this.scopeSchema = ResultSetUtil.getValue(String.class, column, "SCOPE_SCHEMA", null);
        this.scopeTable = ResultSetUtil.getValue(String.class, column, "SCOPE_TABLE", null);
        this.sourceDataType = ResultSetUtil.getValue(Short.TYPE, column, "SOURCE_DATA_TYPE", Short.valueOf((short)0));
        assert (this.tableName != null);
        assert (this.columnName != null);
        assert (this.typeName != null);
        assert (this.nullable != null);
        assert (this.isNullable != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nullable {
        NO_NULLS(0),
        NULLABLE(1),
        UNKNOWN(2);

        private final int value;

        private static Nullable getNullable(short value) {
            for (Nullable nullable : Nullable.values()) {
                if (nullable.value != value) continue;
                return nullable;
            }
            return null;
        }

        private Nullable(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IsNullable {
        YES("YES"),
        NO("NO"),
        UNKNOWN("");

        private final String value;

        private static IsNullable getIsNullable(String value) {
            for (IsNullable nullable : IsNullable.values()) {
                if (!nullable.value.equals(value)) continue;
                return nullable;
            }
            return null;
        }

        private IsNullable(String value) {
            this.value = value;
        }
    }
}

