/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyError;
import org.jiemamy.utils.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceUtil {
    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static File getFile(URL url) {
        Validate.notNull((Object)url);
        File file = new File(ResourceUtil.getFileName(url));
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getFileName(URL url) {
        Validate.notNull((Object)url);
        String s = url.getFile();
        try {
            return URLDecoder.decode(s, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new JiemamyError("This JVM does not support UTF-8 encoding!!", e);
        }
    }

    public static Properties getProperties(String path) throws ResourceNotFoundException, IOException {
        Properties props = new Properties();
        InputStream is = ResourceUtil.getResourceAsStream(path);
        props.load(is);
        return props;
    }

    public static URL getResource(String path) throws ResourceNotFoundException {
        return ResourceUtil.getResource(path, null);
    }

    public static URL getResource(String path, String extension) throws ResourceNotFoundException {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundException(ResourceUtil.getResourcePath(path, extension));
    }

    public static File getResourceAsFile(String path) throws ResourceNotFoundException, UnsupportedEncodingException {
        return ResourceUtil.getResourceAsFile(path, null);
    }

    public static File getResourceAsFile(String path, String extension) throws ResourceNotFoundException, UnsupportedEncodingException {
        return ResourceUtil.getFile(ResourceUtil.getResource(path, extension));
    }

    public static File getResourceAsFileNoException(Class<?> clazz) {
        return ResourceUtil.getResourceAsFileNoException(ResourceUtil.getResourcePath(clazz));
    }

    public static File getResourceAsFileNoException(String path) {
        URL url = ResourceUtil.getResourceNoException(path);
        if (url == null) {
            return null;
        }
        return ResourceUtil.getFile(url);
    }

    public static InputStream getResourceAsStream(String path) throws ResourceNotFoundException, IOException {
        return ResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) throws ResourceNotFoundException, IOException {
        URL url = ResourceUtil.getResource(path, extension);
        return url.openStream();
    }

    public static InputStream getResourceAsStreamNoException(String path) {
        return ResourceUtil.getResourceAsStreamNoException(path, null);
    }

    public static InputStream getResourceAsStreamNoException(String path, String extension) {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResourceNoException(String path) {
        return ResourceUtil.getResourceNoException(path, null);
    }

    public static URL getResourceNoException(String path, String extension) {
        return ResourceUtil.getResourceNoException(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceNoException(String path, String extension, ClassLoader loader) {
        if (path == null || loader == null) {
            return null;
        }
        path = ResourceUtil.getResourcePath(path, extension);
        return loader.getResource(path);
    }

    public static String getResourcePath(Class<?> clazz) {
        Validate.notNull(clazz);
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        extension = "." + extension;
        if (path.endsWith(extension)) {
            return path;
        }
        return path.replace('.', '/') + extension;
    }

    public static boolean isExist(String path) {
        return ResourceUtil.getResourceNoException(path) != null;
    }

    public static String toExternalForm(URL url) throws UnsupportedEncodingException {
        String s = url.toExternalForm();
        return URLDecoder.decode(s, "UTF8");
    }

    private ResourceUtil() {
    }
}

