/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntity
implements Entity {
    final UUID id;

    public AbstractEntity(UUID id) {
        Validate.notNull((Object)id);
        this.id = id;
    }

    @Override
    public AbstractEntity clone() {
        try {
            return (AbstractEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("clone not supported");
        }
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        return this.id.equals(((Entity)obj).getId());
    }

    @Override
    public final UUID getId() {
        return this.id;
    }

    @Override
    public Collection<? extends Entity> getSubEntities() {
        return Collections.emptyList();
    }

    @Override
    public final int hashCode() {
        return this.id.hashCode();
    }

    public EntityRef<? extends AbstractEntity> toReference() {
        return new DefaultEntityRef<AbstractEntity>(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append("@ih=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("/id=").append(this.id.toString().substring(0, 8));
        return sb.toString();
    }
}

