/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.datasource.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.seasar.extension.datasource.DataSourceFactory;
import org.seasar.framework.exception.EmptyRuntimeException;

public class SelectableDataSourceProxy
implements DataSource {
    protected DataSourceFactory dataSourceFactory;

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public DataSource getDataSource() {
        String dataSourceName = this.dataSourceFactory.getSelectableDataSourceName();
        if (dataSourceName == null) {
            throw new EmptyRuntimeException("dataSourceName");
        }
        return this.dataSourceFactory.getDataSource(dataSourceName);
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }
}

