/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import com.google.common.collect.Lists;
import java.util.List;
import org.jiemamy.dddbase.ValueObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueObjectBuilder<T extends ValueObject, S extends ValueObjectBuilder<T, S>> {
    List<BuilderConfigurator<S>> configurators = Lists.newArrayList();

    public T apply(T vo) {
        S builder = this.newInstance();
        this.apply(vo, builder);
        for (BuilderConfigurator<S> configurator : this.configurators) {
            ((ValueObjectBuilder)builder).addConfigurator(configurator);
        }
        return ((ValueObjectBuilder)builder).build();
    }

    public T build() {
        for (BuilderConfigurator<S> configurator : this.configurators) {
            configurator.configure(this.getThis());
        }
        return this.createValueObject();
    }

    protected void addConfigurator(BuilderConfigurator<S> configurator) {
        this.configurators.add(configurator);
    }

    protected abstract void apply(T var1, S var2);

    protected abstract T createValueObject();

    protected abstract S getThis();

    protected abstract S newInstance();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BuilderConfigurator<S> {
        public void configure(S var1);
    }
}

