/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.id;

import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.dao.IdentifierGenerator;
import org.seasar.dao.id.IdentifierResultSetHandler;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;

public abstract class AbstractIdentifierGenerator
implements IdentifierGenerator {
    protected ResultSetHandler resultSetHandler;
    protected PropertyType propertyType;
    protected Dbms dbms;

    public AbstractIdentifierGenerator(PropertyType propertyType, Dbms dbms) {
        this.propertyType = propertyType;
        this.dbms = dbms;
        this.resultSetHandler = new IdentifierResultSetHandler(propertyType.getValueType());
    }

    public String getPropertyName() {
        return this.propertyType.getPropertyName();
    }

    public Dbms getDbms() {
        return this.dbms;
    }

    protected Object executeSql(DataSource ds, String sql, Object[] args) {
        BasicSelectHandler handler = new BasicSelectHandler(ds, sql, this.resultSetHandler);
        handler.setFetchSize(-1);
        return handler.execute(args);
    }

    protected void setIdentifier(Object bean, Object value) {
        if (this.propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        PropertyDesc pd = this.propertyType.getPropertyDesc();
        pd.setValue(bean, value);
    }
}

