/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.annotation.tiger.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.seasar.dao.annotation.tiger.ProcedureParameter;
import org.seasar.dao.annotation.tiger.ValueType;
import org.seasar.dao.impl.FieldArgumentDtoAnnotationReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentDtoAnnotationReaderImpl
extends FieldArgumentDtoAnnotationReader {
    public String getProcedureParameter(BeanDesc dtoDesc, Field field) {
        ProcedureParameter parameter = this.getAnnotation(dtoDesc, field, ProcedureParameter.class);
        if (parameter != null) {
            return parameter.value().name().toLowerCase();
        }
        return super.getProcedureParameter(dtoDesc, field);
    }

    public String getValueType(BeanDesc dtoDesc, Field field) {
        ValueType valueType = this.getAnnotation(dtoDesc, field, ValueType.class);
        if (valueType != null) {
            return valueType.value();
        }
        return super.getValueType(dtoDesc, field);
    }

    protected <T extends Annotation> T getAnnotation(BeanDesc beanDesc, Field field, Class<T> annotationClass) {
        if (field.isAnnotationPresent(annotationClass)) {
            return field.getAnnotation(annotationClass);
        }
        if (beanDesc.hasPropertyDesc(field.getName())) {
            Method method;
            PropertyDesc pd = beanDesc.getPropertyDesc(field.getName());
            if (pd.hasWriteMethod() && (method = pd.getWriteMethod()).isAnnotationPresent(annotationClass)) {
                return method.getAnnotation(annotationClass);
            }
            if (pd.hasReadMethod()) {
                method = pd.getReadMethod();
                return method.getAnnotation(annotationClass);
            }
        }
        return null;
    }
}

