/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.model.constraint.JmNotNullConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;
import org.jiemamy.validator.impl.ReferenceProblem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNullConstraintValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            for (JmNotNullConstraint nn : table.getConstraints(JmNotNullConstraint.class)) {
                if (nn.getColumn() == null) {
                    problems.add(new NullTargetProblem(table, nn));
                }
                try {
                    table.resolve(nn.getColumn());
                }
                catch (EntityNotFoundException e) {
                    problems.add(new ReferenceProblem((Entity)nn, nn.getColumn()));
                }
            }
        }
        return problems;
    }

    static class NullTargetProblem
    extends AbstractProblem {
        public NullTargetProblem(JmTable table, JmNotNullConstraint nn) {
            super(nn, "F0180", new Object[]{table.getName(), nn.getName()});
        }
    }
}

