/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.codehaus.staxmate.out.SMNamespace;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.JmMetadata;
import org.jiemamy.Version;
import org.jiemamy.model.DbObject;
import org.jiemamy.model.dataset.JmDataSet;
import org.jiemamy.serializer.DbObjectComparator;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreNamespace;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JiemamyContextStaxHandler
extends StaxHandler<JiemamyContext> {
    private static Logger logger = LoggerFactory.getLogger(JiemamyContextStaxHandler.class);

    public JiemamyContextStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JiemamyContext handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.JIEMAMY));
            JiemamyContext context = dctx.getContext();
            JiemamyCursor cursor = dctx.peek();
            String versionString = cursor.getAttrValue(CoreQName.VERSION);
            this.verifyVersionCompatibility(versionString);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                JiemamyCursor dataSetsCursor;
                block15: {
                    JiemamyCursor dbObjectsCursor;
                    block17: {
                        block16: {
                            childCursor.advance();
                            if (childCursor.getCurrEvent() != SMEvent.START_ELEMENT) break block16;
                            if (childCursor.isQName(CoreQName.META)) {
                                JmMetadata meta = (JmMetadata)this.getDirector().direct(dctx);
                                if (meta != null) {
                                    context.setMetadata(meta);
                                    continue;
                                }
                                logger.warn("null meta");
                                continue;
                            }
                            if (childCursor.isQName(CoreQName.DBOBJECTS)) {
                                dbObjectsCursor = childCursor.childElementCursor();
                                break block17;
                            } else if (childCursor.isQName(CoreQName.DATASETS)) {
                                dataSetsCursor = childCursor.childElementCursor();
                                break block15;
                            } else {
                                this.getDirector().direct(dctx);
                                continue;
                            }
                        }
                        if (childCursor.getCurrEvent() == null) continue;
                        logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                        continue;
                    }
                    while (dbObjectsCursor.getNext() != null) {
                        dctx.push(dbObjectsCursor);
                        DbObject dbObject = (DbObject)this.getDirector().direct(dctx);
                        if (dbObject != null) {
                            context.store(dbObject);
                        } else {
                            logger.warn("null dbObject");
                        }
                        dctx.pop();
                    }
                    continue;
                }
                while (dataSetsCursor.getNext() != null) {
                    dctx.push(dataSetsCursor);
                    JmDataSet dataSet = (JmDataSet)this.getDirector().direct(dctx);
                    if (dataSet != null) {
                        context.store(dataSet);
                    } else {
                        logger.warn("null dataSet");
                    }
                    dctx.pop();
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return context;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(JiemamyContext model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.JIEMAMY);
            sctx.push(element);
            SMNamespace xsiNs = element.getSMOutputElement().getNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            element.addAttribute((JiemamyQName)CoreQName.VERSION, JiemamyContext.getVersion().toStringSpec());
            element.addAttribute(xsiNs, "schemaLocation", this.getSchemaLocationDefinition(CoreNamespace.values()));
            JmMetadata meta = model.getMetadata();
            if (meta != null) {
                this.getDirector().direct(meta, sctx);
            }
            ArrayList dbObjects = Lists.newArrayList(model.getDbObjects());
            Collections.sort(dbObjects, DbObjectComparator.INSTANCE);
            sctx.push(element.addElement(CoreQName.DBOBJECTS));
            for (DbObject dbObject : dbObjects) {
                this.getDirector().direct(dbObject, sctx);
            }
            sctx.pop();
            sctx.push(element.addElement(CoreQName.DATASETS));
            for (JmDataSet dataSet : model.getDataSets()) {
                this.getDirector().direct(dataSet, sctx);
            }
            sctx.pop();
            for (JiemamyFacet facet : model.getFacets()) {
                this.getDirector().direct(facet, sctx);
            }
            sctx.pop();
            parent.addCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    private void verifyVersionCompatibility(String versionString) throws SerializationException {
        Version parsed = Version.parse(versionString);
        Version myVersion = JiemamyContext.getVersion();
        if (!myVersion.canDeserialize(parsed)) {
            String message = MessageFormat.format("Jiemamy v{0} cannot deserialize v{1} data.", myVersion.toString(), parsed.toString());
            throw new SerializationException(message);
        }
    }
}

