/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans;

import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.MethodUtil;

public class MethodNotFoundRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = -3508955801981550317L;
    private Class targetClass;
    private String methodName;
    private Class[] methodArgClasses;

    public MethodNotFoundRuntimeException(Class targetClass, String methodName, Object[] methodArgs) {
        super("ESSR0049", new Object[]{targetClass.getName(), MethodUtil.getSignature(methodName, methodArgs)});
        this.targetClass = targetClass;
        this.methodName = methodName;
        if (methodArgs != null) {
            this.methodArgClasses = new Class[methodArgs.length];
            for (int i = 0; i < methodArgs.length; ++i) {
                if (methodArgs[i] == null) continue;
                this.methodArgClasses[i] = methodArgs[i].getClass();
            }
        }
    }

    public MethodNotFoundRuntimeException(Class targetClass, String methodName, Class[] methodArgClasses) {
        super("ESSR0049", new Object[]{targetClass.getName(), MethodUtil.getSignature(methodName, methodArgClasses)});
        this.targetClass = targetClass;
        this.methodName = methodName;
        this.methodArgClasses = methodArgClasses;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class[] getMethodArgClasses() {
        return this.methodArgClasses;
    }
}

