/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriPathテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuripath {

	private Long pathid;
	private String pathname = "";
	private String realpathname = "";
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathid() {
		return pathid;
	}

	/**
	 * PathIDを設定します。
	 * @param pathid PathID
	 */
	public void setPathid(Long pathid) {
		modifiedPropertySet.add("pathid");
		this.pathid = pathid;
	}

	/**
	 * PathNameを返します。
	 * @return PathName
	 */
	@org.seasar.dao.annotation.tiger.Column("PathName")
	public String getPathname() {
		return pathname;
	}

	/**
	 * PathNameを設定します。
	 * @param pathname PathName
	 */
	public void setPathname(String pathname) {
		modifiedPropertySet.add("pathname");
		this.pathname = pathname;
	}

	/**
	 * RealPathNameを返します。
	 * @return RealPathName
	 */
	@org.seasar.dao.annotation.tiger.Column("RealPathName")
	public String getRealpathname() {
		return realpathname;
	}

	/**
	 * RealPathNameを設定します。
	 * @param realpathname RealPathName
	 */
	public void setRealpathname(String realpathname) {
		modifiedPropertySet.add("realpathname");
		this.realpathname = realpathname;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/pathid=").append(pathid);
		buff.append("/pathname=").append(pathname);
		buff.append("/realpathname=").append(realpathname);
		buff.append("]");
		return buff.toString();
	}

}
