/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.unit.util;

import org.seasar.codegen.element.FieldSetting;

public class FieldSettingUtil {

    public static FieldSetting createFieldSetting(String typeName,
            String isNotNull) {
        FieldSetting ret = new FieldSetting();
        ret.setTypeName(typeName);
        ret.setNotNull(Boolean.parseBoolean(isNotNull));
        ret.setFieldDefault("");
        ret.setColmnSize(2);
        return ret;
    }
}
