/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dddbase;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.OnMemoryRepository;
import org.jiemamy.dddbase.OrderedEntity;
import org.jiemamy.dddbase.OrderedRepository;
import org.jiemamy.dddbase.utils.CloneUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedOnMemoryRepository<T extends OrderedEntity>
extends OnMemoryRepository<T>
implements OrderedRepository<T> {
    private List<T> list = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OrderedOnMemoryRepository<T> clone() {
        OrderedOnMemoryRepository clone;
        OrderedOnMemoryRepository orderedOnMemoryRepository = clone = (OrderedOnMemoryRepository)super.clone();
        synchronized (orderedOnMemoryRepository) {
            clone.list = CloneUtil.cloneEntityArrayList(this.list);
        }
        return clone;
    }

    @Override
    public synchronized T delete(EntityRef<? extends T> ref) {
        OrderedEntity deleted = (OrderedEntity)super.delete(ref);
        this.list.remove(deleted);
        for (int i = 0; i < this.list.size(); ++i) {
            ((OrderedEntity)this.list.get(i)).setIndex(i);
        }
        return (T)deleted;
    }

    @Override
    public synchronized List<T> getEntitiesAsList() {
        return CloneUtil.cloneEntityArrayList(this.list);
    }

    @Override
    public synchronized T store(T entity) {
        OrderedEntity old;
        if (this.list.contains(entity)) {
            int index = this.list.indexOf(entity);
            old = (OrderedEntity)super.store(entity);
            entity.setIndex(index);
            OrderedEntity clone = entity.clone();
            this.list.set(index, clone);
            for (int i = index + 1; i < this.list.size(); ++i) {
                ((OrderedEntity)this.list.get(i)).setIndex(i);
            }
        } else {
            OrderedEntity target;
            if (entity.getIndex() < 0 || entity.getIndex() >= this.list.size()) {
                OrderedEntity clone;
                entity.setIndex(this.list.size());
                target = clone = entity.clone();
            } else {
                OrderedEntity clone;
                target = clone = entity.clone();
                for (int i = clone.getIndex(); i < this.list.size(); ++i) {
                    super.store(target);
                    target = this.list.set(i, target);
                    target.setIndex(i + 1);
                }
            }
            old = super.store(target);
            this.list.add(target);
        }
        return (T)old;
    }

    @Override
    public synchronized void swap(int index1, int index2) {
        Collections.swap(this.list, index1, index2);
        ((OrderedEntity)this.list.get(index1)).setIndex(index1);
        ((OrderedEntity)this.list.get(index2)).setIndex(index2);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtils.getShortClassName(this.getClass()));
        sb.append("@ih=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(this.list.toString());
        return sb.toString();
    }
}

