/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.seasar.buri.oouo.internal.structure.BuriActivityType;
import org.seasar.buri.oouo.internal.structure.BuriPackageType;
import org.seasar.buri.oouo.internal.structure.BuriWorkflowProcessType;
import org.seasar.framework.util.StringUtil;

public class BuriRealPath {
    private String workflowPackage = "";
    private String workflowProcess = "";
    private ArrayList activity = new ArrayList();
    private String pathStr = "";
    static final /* synthetic */ boolean $assertionsDisabled;

    public BuriRealPath() {
        this("");
    }

    public BuriRealPath(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(path, ".");
        this.setPathFromToken(st);
        this.pathStr = path;
    }

    public BuriRealPath copyRealPath() {
        BuriRealPath clonePath = new BuriRealPath();
        clonePath.workflowPackage = this.workflowPackage;
        clonePath.workflowProcess = this.workflowProcess;
        clonePath.activity.addAll(this.activity);
        clonePath.pathStr = this.pathStr;
        return clonePath;
    }

    protected void setPathFromToken(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            this.workflowPackage = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.workflowProcess = st.nextToken();
        }
        ArrayList<String> activity = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            activity.add(st.nextToken());
        }
        this.activity = activity;
        this.setupPlainName();
    }

    public void changePash(String newPath, int pos) {
        if (StringUtil.isEmpty((String)newPath)) {
            newPath = "";
        }
        if (this.activity.size() == 0) {
            this.getActivity().add(newPath);
        } else {
            if (!$assertionsDisabled && pos >= this.activity.size()) {
                throw new AssertionError();
            }
            this.activity.set(pos, newPath);
        }
        this.setupPlainName();
    }

    public void changePath(BuriActivityType newAct, int pos) {
        this.changePash(newAct.getName(), pos);
    }

    public void moveChildPath(String childPath) {
        this.activity.add(childPath);
        this.setupPlainName();
    }

    public void moveChildPath(BuriActivityType newAct) {
        this.moveChildPath(newAct.getName());
        this.setupPlainName();
    }

    public void moveUpPath() {
        if (this.activity.size() == 0) {
            return;
        }
        this.activity.remove(this.activity.size() - 1);
        this.setupPlainName();
    }

    public List getActivity() {
        return new ArrayList(this.activity);
    }

    public void setActivity(List activity) {
        activity.clear();
        activity.addAll(activity);
        this.setupPlainName();
    }

    public String getWorkflowProcess() {
        return this.workflowProcess;
    }

    public void setWorkflowProcess(String process) {
        this.workflowProcess = StringUtil.isEmpty((String)process) ? "" : process;
        this.setupPlainName();
    }

    public void setWorkflowProcess(BuriWorkflowProcessType wkfProcess) {
        this.setWorkflowProcess(wkfProcess.getName());
        this.setupPlainName();
    }

    public String getWorkflowPackage() {
        return this.workflowPackage;
    }

    public void setWorkflowPackage(String workflow) {
        this.workflowPackage = StringUtil.isEmpty((String)workflow) ? "" : workflow;
        this.setupPlainName();
    }

    public void setWorkflowPackage(BuriPackageType packageDoc) {
        this.setWorkflowPackage(packageDoc.getName());
        this.setupPlainName();
    }

    public String getPlainName() {
        return this.pathStr;
    }

    protected void setupPlainName() {
        String path = this.workflowPackage + "." + this.workflowProcess;
        String act = "";
        String koron = "";
        Iterator ite = this.activity.iterator();
        while (ite.hasNext()) {
            act = act + koron + ite.next();
            koron = ".";
        }
        this.pathStr = path + koron + act;
    }

    public String toString() {
        return this.pathStr;
    }

    protected boolean isCorrect() {
        if (this.hasPathName(this.getWorkflowPackage()) && this.hasPathName(this.getWorkflowProcess())) {
            return this.isCorrectActivitys(this.getActivity());
        }
        return false;
    }

    protected boolean isCorrectActivitys(List activitis) {
        Iterator ite = activitis.iterator();
        while (ite.hasNext()) {
            String pathName = (String)ite.next();
            if (this.hasPathName(pathName)) continue;
            return false;
        }
        return true;
    }

    protected boolean hasPathName(String pathName) {
        return pathName.length() > 0;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.workflowPackage == null ? 0 : this.workflowPackage.hashCode());
        hashCode = 31 * hashCode + (this.workflowProcess == null ? 0 : this.workflowProcess.hashCode());
        hashCode = 31 * hashCode + (this.activity == null ? 0 : this.activity.hashCode());
        hashCode = 31 * hashCode + (this.pathStr == null ? 0 : this.pathStr.hashCode());
        return hashCode;
    }

    static {
        $assertionsDisabled = !BuriRealPath.class.desiredAssertionStatus();
    }
}

