/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.constraint.JmPrimaryKeyConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKeyValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList result = Lists.newArrayList();
        Set<JmTable> tables = context.getTables();
        for (JmTable table : tables) {
            int size = table.getConstraints(JmPrimaryKeyConstraint.class).size();
            if (size == 0) {
                result.add(new NoPrimaryKeyProblem(table));
                continue;
            }
            if (size <= 1) continue;
            result.add(new MultiplePrimaryKeyProblem(table));
        }
        return result;
    }

    static class NoPrimaryKeyProblem
    extends AbstractProblem {
        public NoPrimaryKeyProblem(JmTable table) {
            super(table, "N0080", new Object[]{table.getName()});
        }
    }

    static class MultiplePrimaryKeyProblem
    extends AbstractProblem {
        public MultiplePrimaryKeyProblem(JmTable table) {
            super(table, "F0150", new Object[]{table.getName()});
        }
    }
}

