/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.JiemamyFacet;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdCollisionValidator
extends AbstractValidator {
    private static Logger logger = LoggerFactory.getLogger(IdCollisionValidator.class);

    @Override
    public Collection<? extends Problem> validate(JiemamyContext context) {
        HashSet uuid = Sets.newHashSet();
        Validate.notNull((Object)context);
        ArrayList problems = Lists.newArrayList();
        ArrayList entities = Lists.newArrayList();
        entities.addAll(context.getDbObjects());
        entities.addAll(context.getDataSets());
        for (JiemamyFacet facet : context.getFacets()) {
            entities.addAll(facet.getEntities());
        }
        for (Entity entity : entities) {
            this.check(entity, uuid, problems);
        }
        return problems;
    }

    void check(Entity entity, Set<UUID> uuid, Collection<Problem> problems) {
        this.check0(entity, uuid, problems);
        Collection subEntities = entity.getSubEntities();
        for (Entity subEntity : subEntities) {
            this.check(subEntity, uuid, problems);
        }
    }

    void check0(Entity entity, Set<UUID> uuid, Collection<Problem> problems) {
        if (uuid.contains(entity.getId())) {
            problems.add(new IdCollisionProblem(entity));
            logger.warn("collision : " + entity.getId());
        }
        uuid.add(entity.getId());
    }

    static class IdCollisionProblem
    extends AbstractProblem {
        IdCollisionProblem(Entity entity) {
            super(null, "F0110", new Object[]{entity.getId(), entity.toString(), null});
        }
    }
}

