/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jiemamy.JiemamyContext;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        for (JmTable table : context.getTables()) {
            for (JmForeignKeyConstraint jmForeignKeyConstraint : table.getForeignKeyConstraints()) {
                if (jmForeignKeyConstraint.getKeyColumns().size() != jmForeignKeyConstraint.getReferenceColumns().size()) {
                    problems.add(new ReferenceMappingProblem(jmForeignKeyConstraint));
                }
                if (jmForeignKeyConstraint.findReferencedKeyConstraint(context.getTables()) != null) continue;
                problems.add(new ReferenceKeyProblem(jmForeignKeyConstraint));
            }
        }
        return problems;
    }

    static class ReferenceMappingProblem
    extends AbstractProblem {
        public ReferenceMappingProblem(JmForeignKeyConstraint foreignKey) {
            super(foreignKey, "F0220", new Object[]{foreignKey.getName(), foreignKey.getKeyColumns().size(), foreignKey.getReferenceColumns().size()});
        }
    }

    static class ReferenceKeyProblem
    extends AbstractProblem {
        public ReferenceKeyProblem(JmForeignKeyConstraint foreignKey) {
            super(foreignKey, "F0200", new Object[]{foreignKey.getName(), foreignKey.getKeyColumns().size(), foreignKey.getReferenceColumns().size()});
        }
    }
}

