/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jiemamy.model.constraint.JmCheckConstraint;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.constraint.JmForeignKeyConstraint;
import org.jiemamy.model.constraint.JmNotNullConstraint;
import org.jiemamy.model.constraint.JmPrimaryKeyConstraint;
import org.jiemamy.model.constraint.JmUniqueKeyConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintComparator
implements Comparator<JmConstraint> {
    public static final ConstraintComparator INSTANCE = new ConstraintComparator();
    private static final ImmutableList<Class<? extends JmConstraint>> ORDER;

    private static int getOrder(Class<?>[] interfaces) {
        for (Class<?> interf : interfaces) {
            int index = ORDER.indexOf(interf);
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    private ConstraintComparator() {
    }

    @Override
    public int compare(JmConstraint o1, JmConstraint o2) {
        int compareName;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int i1 = ConstraintComparator.getOrder(this.getAncestorIntefaces(o1.getClass()));
        int i2 = ConstraintComparator.getOrder(this.getAncestorIntefaces(o2.getClass()));
        if (i1 != -1 && i2 != -1) {
            if (i1 != i2) {
                return i1 - i2;
            }
        } else {
            if (i1 == -1 && i2 != -1) {
                return 1;
            }
            if (i1 != -1 && i2 == -1) {
                return -1;
            }
        }
        if ((compareName = o1.getClass().getName().compareTo(o2.getClass().getName())) != 0) {
            return compareName;
        }
        return o1.getId().compareTo(o2.getId());
    }

    private Class<?>[] getAncestorIntefaces(Class<?> clazz) {
        if (clazz == null) {
            return new Class[0];
        }
        ArrayList collector = Lists.newArrayList();
        Class<?>[] interfaces = clazz.getInterfaces();
        collector.addAll(Arrays.asList(interfaces));
        for (Class<?> iface : interfaces) {
            collector.addAll(Arrays.asList(this.getAncestorIntefaces(iface)));
        }
        if (clazz != Object.class) {
            collector.addAll(Arrays.asList(this.getAncestorIntefaces(clazz.getSuperclass())));
        }
        return collector.toArray(new Class[collector.size()]);
    }

    static {
        ArrayList order = Lists.newArrayList();
        order.add(JmPrimaryKeyConstraint.class);
        order.add(JmUniqueKeyConstraint.class);
        order.add(JmForeignKeyConstraint.class);
        order.add(JmNotNullConstraint.class);
        order.add(JmCheckConstraint.class);
        ORDER = ImmutableList.copyOf((Iterable)order);
    }
}

