/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import org.apache.commons.lang.Validate;
import org.jiemamy.ServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeServiceLocator
implements ServiceLocator {
    private final ServiceLocator[] locators;

    public CompositeServiceLocator(ServiceLocator ... locators) {
        Validate.noNullElements((Object[])locators);
        this.locators = locators;
    }

    @Override
    public <T> T getService(Class<T> clazz, String fqcn) throws ClassNotFoundException {
        for (ServiceLocator locator : this.locators) {
            T service = null;
            try {
                service = locator.getService(clazz, fqcn);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (service == null) continue;
            return service;
        }
        throw new ClassNotFoundException();
    }
}

