/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.table;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import org.jiemamy.dddbase.AbstractEntityFactory;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.JmConstraint;
import org.jiemamy.model.table.SimpleJmTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmTableBuilder
extends AbstractEntityFactory<SimpleJmTable> {
    List<JmColumn> columns = Lists.newArrayList();
    List<JmConstraint> constraints = Lists.newArrayList();
    String name;

    public JmTableBuilder() {
    }

    public JmTableBuilder(String name) {
        this.name = name;
    }

    public SimpleJmTable build(UUID id) {
        SimpleJmTable table = new SimpleJmTable(id);
        table.setName(this.name);
        for (JmColumn column : this.columns) {
            table.store(column);
        }
        for (JmConstraint constraint : this.constraints) {
            table.store(constraint);
        }
        return table;
    }

    public JmTableBuilder name(String name) {
        this.name = name;
        return this;
    }

    public JmTableBuilder with(JmColumn ... columns) {
        for (JmColumn column : columns) {
            this.with(column);
        }
        return this;
    }

    public JmTableBuilder with(JmColumn column) {
        this.columns.add(column);
        return this;
    }

    public JmTableBuilder with(JmConstraint constraint) {
        this.constraints.add(constraint);
        return this;
    }
}

