/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.domain;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.dddbase.OnMemoryRepository;
import org.jiemamy.model.SimpleDbObject;
import org.jiemamy.model.constraint.JmCheckConstraint;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.RawTypeCategory;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.domain.JmDomain;
import org.jiemamy.model.parameter.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmDomain
extends SimpleDbObject
implements JmDomain {
    private DataType dataType;
    private OnMemoryRepository<JmCheckConstraint> checkConstraints = new OnMemoryRepository();
    private boolean notNull;
    private ParameterMap params = new ParameterMap();

    public SimpleJmDomain() {
        this(UUID.randomUUID());
    }

    public SimpleJmDomain(UUID id) {
        super(id);
    }

    public void addCheckConstraint(JmCheckConstraint checkConstraint) {
        Validate.notNull((Object)checkConstraint);
        this.checkConstraints.store((Entity)checkConstraint);
    }

    @Override
    public RawTypeDescriptor asType() {
        return new DomainType();
    }

    @Override
    public SimpleJmDomain clone() {
        SimpleJmDomain clone = (SimpleJmDomain)super.clone();
        clone.checkConstraints = this.checkConstraints.clone();
        clone.params = this.params.clone();
        return clone;
    }

    @Override
    public Collection<? extends JmCheckConstraint> getCheckConstraints() {
        return this.checkConstraints.getEntitiesAsSet();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public <T> T getParam(TypeParameterKey<T> key) {
        return this.params.get(key);
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    public <T> void putParam(TypeParameterKey<T> key, T value) {
        this.params.put(key, value);
    }

    public void removeParam(TypeParameterKey<?> key) {
        this.params.remove(key);
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public EntityRef<? extends SimpleJmDomain> toReference() {
        return new DefaultEntityRef((Entity)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DomainType
    extends DefaultEntityRef<JmDomain>
    implements RawTypeDescriptor {
        DomainType() {
            super((Entity)SimpleJmDomain.this);
        }

        @Override
        public Collection<String> getAliasTypeNames() {
            return Collections.emptyList();
        }

        @Override
        public RawTypeCategory getCategory() {
            return SimpleJmDomain.this.dataType.getRawTypeDescriptor().getCategory();
        }

        public <T> T getParam(TypeParameterKey<T> key) {
            return SimpleJmDomain.this.dataType.getParam(key);
        }

        public ParameterMap getParams() {
            return SimpleJmDomain.this.dataType.getParams();
        }

        @Override
        public String getTypeName() {
            return SimpleJmDomain.this.dataType.getRawTypeDescriptor().getTypeName();
        }

        public RawTypeDescriptor getTypeReference() {
            return SimpleJmDomain.this.dataType.getRawTypeDescriptor();
        }
    }
}

