/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.datatype;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.datatype.RawTypeDescriptor;
import org.jiemamy.model.datatype.SimpleDataType;
import org.jiemamy.model.parameter.ParameterMap;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleDataTypeStaxHandler
extends StaxHandler<SimpleDataType> {
    private static Logger logger = LoggerFactory.getLogger(SimpleDataTypeStaxHandler.class);

    public SimpleDataTypeStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleDataType handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.DATA_TYPE));
            JiemamyCursor cursor = dctx.peek();
            RawTypeDescriptor typeDesc = null;
            HashMap params = Maps.newHashMap();
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                JiemamyCursor parameterCursor;
                block11: {
                    childCursor.advance();
                    if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                        if (childCursor.isQName(CoreQName.TYPE_DESC)) {
                            typeDesc = (RawTypeDescriptor)this.getDirector().direct(dctx);
                            continue;
                        }
                        if (childCursor.isQName(CoreQName.PARAMETERS)) {
                            parameterCursor = childCursor.childElementCursor();
                            break block11;
                        } else {
                            logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                            continue;
                        }
                    }
                    if (childCursor.getCurrEvent() == null) continue;
                    logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
                    continue;
                }
                while (parameterCursor.getNext() != null) {
                    if (!parameterCursor.isQName(CoreQName.PARAMETER)) {
                        logger.warn("unexpected: " + parameterCursor.getQName());
                        continue;
                    }
                    params.put(parameterCursor.getAttrValue(CoreQName.PARAMETER_KEY), parameterCursor.collectDescendantText(false));
                }
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            SimpleDataType dataType = new SimpleDataType(typeDesc);
            Iterator i$ = params.entrySet().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    return dataType;
                }
                Map.Entry entry = i$.next();
                dataType.putParam((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleDataType model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.DATA_TYPE);
            sctx.push(element);
            this.getDirector().direct(model.getRawTypeDescriptor(), sctx);
            sctx.pop();
            ParameterMap params = model.getParams();
            if (params.size() > 0) {
                JiemamyOutputElement paramesElement = element.addElement(CoreQName.PARAMETERS);
                ArrayList paramList = Lists.newArrayList((Iterable)params);
                Collections.sort(paramList, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                        return e1.getKey().compareTo(e2.getKey());
                    }
                });
                for (Map.Entry param : paramList) {
                    JiemamyOutputElement paramElement = paramesElement.addElement(CoreQName.PARAMETER);
                    paramElement.addAttribute((JiemamyQName)CoreQName.PARAMETER_KEY, (String)param.getKey());
                    paramElement.addCharacters((String)param.getValue());
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

