/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.dataset;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityNotFoundException;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.dataset.SimpleJmRecord;
import org.jiemamy.script.PlainScriptEngine;
import org.jiemamy.script.ScriptString;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmRecordStaxHandler
extends StaxHandler<SimpleJmRecord> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmRecordStaxHandler.class);

    public SimpleJmRecordStaxHandler(StaxDirector director) {
        super(director);
    }

    @Override
    public SimpleJmRecord handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.RECORDS));
            JiemamyCursor cursor = dctx.peek();
            HashMap values = Maps.newHashMap();
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.RECORD)) {
                        String strRef = childCursor.getAttrValue(CoreQName.REF);
                        assert (strRef != null);
                        UUID referenceId = dctx.getContext().toUUID(strRef);
                        DefaultEntityRef columnRef = DefaultEntityRef.of((UUID)referenceId);
                        String engine = PlainScriptEngine.class.getName();
                        if (childCursor.hasAttr(CoreQName.ENGINE)) {
                            engine = childCursor.getAttrValue(CoreQName.ENGINE);
                        }
                        String value = childCursor.collectDescendantText(false);
                        values.put(columnRef, new ScriptString(value, engine));
                        continue;
                    }
                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return new SimpleJmRecord(values);
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmRecord model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement recordsElement = parent.addElement(CoreQName.RECORDS);
            sctx.push(recordsElement);
            JiemamyContext context = sctx.getContext();
            Iterable<Map.Entry<EntityRef<? extends JmColumn>, ScriptString>> values = model.toIterable(sctx.getContext(), sctx.getCurrentTableRef());
            for (Map.Entry<EntityRef<? extends JmColumn>, ScriptString> entry : values) {
                EntityRef<? extends JmColumn> columnRef = entry.getKey();
                ScriptString value = entry.getValue();
                if (JiemamyContext.isDebug()) {
                    try {
                        String name = context.resolve(columnRef).getName();
                        recordsElement.addComment(" ColumnName: " + name + " ");
                    }
                    catch (EntityNotFoundException e3) {
                        recordsElement.addComment(" !!! JmColumnBuilder cannot resolved !!! ");
                    }
                }
                JiemamyOutputElement recordElement = recordsElement.addElement(CoreQName.RECORD);
                recordElement.addAttribute((JiemamyQName)CoreQName.REF, columnRef.getReferentId());
                recordElement.addAttribute((JiemamyQName)CoreQName.ENGINE, value.getScriptEngineClassName());
                recordElement.addCharacters(value.getScript());
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

