/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.dddbase.DefaultEntityRef;
import org.jiemamy.dddbase.EntityRef;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.model.constraint.SimpleJmUniqueKeyConstraint;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleJmUniqueKeyConstraintStaxHandler
extends StaxHandler<SimpleJmUniqueKeyConstraint> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmUniqueKeyConstraintStaxHandler.class);

    public SimpleJmUniqueKeyConstraintStaxHandler(StaxDirector director) {
        super(director);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SimpleJmUniqueKeyConstraint handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.UNIQUE_KEY));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmUniqueKeyConstraint uk = new SimpleJmUniqueKeyConstraint(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.NAME)) {
                        uk.setName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                        uk.setLogicalName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        uk.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DEFERRABILITY)) {
                        SimpleJmDeferrability deferrability = (SimpleJmDeferrability)this.getDirector().direct(dctx);
                        uk.setDeferrability(deferrability);
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.KEY_COLUMNS)) {
                        JiemamyCursor keyColumnsCursor = childCursor.childElementCursor();
                        while (keyColumnsCursor.getNext() != null) {
                            String idStr = keyColumnsCursor.getAttrValue(CoreQName.REF);
                            UUID refid = dctx.getContext().toUUID(idStr);
                            DefaultEntityRef columnRef = DefaultEntityRef.of((UUID)refid);
                            uk.addKeyColumn((EntityRef<? extends JmColumn>)columnRef);
                        }
                        continue;
                    } else {
                        logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                        continue;
                    }
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return uk;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmUniqueKeyConstraint model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.UNIQUE_KEY);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            JiemamyOutputElement keyColumnsElement = element.addElement(CoreQName.KEY_COLUMNS);
            for (EntityRef<? extends JmColumn> columnRef : model.getKeyColumns()) {
                keyColumnsElement.addElement(CoreQName.COLUMN_REF).addAttribute((JiemamyQName)CoreQName.REF, columnRef.getReferentId());
            }
            sctx.push(element);
            if (model.getDeferrability() != null) {
                this.getDirector().direct(model.getDeferrability(), sctx);
            }
            sctx.pop();
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

